/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="lemonskin")
public class ModConfig {
    @Config.Name(value="client")
    @Config.Comment(value={"These config settings are client-side only"})
    public static ClientCategory CLIENT = new ClientCategory();

    @Mod.EventBusSubscriber(modid="lemonskin")
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("lemonskin")) {
                ConfigManager.sync((String)"lemonskin", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ClientCategory {
        @Config.Name(value="Use Modern Tooltip Rendering")
        @Config.LangKey(value="use.modern.tooltip")
        @Config.Comment(value={"true  \u2013 draw bars directly inside the tooltip\nfalse \u2013 draw on a separate floating background (legacy)"})
        public boolean USE_MODERN_TOOLTIP = true;
        @Config.Name(value="Show Food Values in Tooltip")
        @Config.LangKey(value="show.food.values.in.tooltip")
        @Config.Comment(value={"If true, shows the hunger and saturation values of food in its tooltip while holding SHIFT"})
        public boolean SHOW_FOOD_VALUES_IN_TOOLTIP = false;
        @Config.Name(value="Show Food Values in Tooltip Always")
        @Config.LangKey(value="show.food.values.in.tooltip.always")
        @Config.Comment(value={"If true, shows the hunger and saturation values of food in its tooltip automatically (without needing to hold SHIFT)"})
        public boolean ALWAYS_SHOW_FOOD_VALUES_TOOLTIP = true;
        @Config.Name(value="Show Saturation HUD Overlay")
        @Config.LangKey(value="show.saturation.hud.overlay")
        @Config.Comment(value={"If true, shows your current saturation level overlayed on the hunger bar"})
        public boolean SHOW_SATURATION_OVERLAY = true;
        @Config.Name(value="Show Food Values HUD Overlay")
        @Config.LangKey(value="show.food.values.hud.overlay")
        @Config.Comment(value={"If true, shows the hunger (and saturation if show.saturation.hud.overlay is true) that would be restored by food you are currently holding"})
        public boolean SHOW_FOOD_VALUES_OVERLAY = true;
        @Config.Name(value="Show Exhaustion HUD Underlay")
        @Config.LangKey(value="show.food.exhaustion.hud.underlay")
        @Config.Comment(value={"If true, shows your food exhaustion as a progress bar behind the hunger bars"})
        public boolean SHOW_FOOD_EXHAUSTION_UNDERLAY = true;
        @Config.Name(value="Show Food Health HUD Overlay")
        @Config.LangKey(value="show.food.health.hud.overlay")
        @Config.Comment(value={"SHOW_FOOD_HEALTH_HUD_OVERLAY"})
        public boolean SHOW_FOOD_HEALTH_HUD_OVERLAY = false;
        @Config.Name(value="Show Vanilla Animations Overlay")
        @Config.LangKey(value="show.vanilla.animations.overlay")
        @Config.Comment(value={"If true, hunger/health overlay will shake to match Minecraft's icon animations"})
        public boolean SHOW_VANILLA_ANIMATION_OVERLAY = true;
        @Config.Name(value="Show Food Stats in F3")
        @Config.LangKey(value="show.food.stats.in.debug.overlay")
        @Config.Comment(value={"If true, adds a line that shows your hunger, saturation, and exhaustion level in the F3 debug overlay"})
        public boolean SHOW_FOOD_DEBUG_INFO = true;
    }
}

