/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.client;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.FoodStats;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ua.myxazaur.lemonskin.ModConfig;
import ua.myxazaur.lemonskin.helpers.HungerHelper;

@SideOnly(value=Side.CLIENT)
public class DebugInfoHandler {
    private static final DecimalFormat saturationDF = new DecimalFormat("#.##");
    private static final DecimalFormat exhaustionValDF = new DecimalFormat("0.00");
    private static final DecimalFormat exhaustionMaxDF = new DecimalFormat("#.##");

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new DebugInfoHandler());
    }

    @SubscribeEvent
    public void onTextRender(RenderGameOverlayEvent.Text textEvent) {
        if (textEvent.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if (!ModConfig.CLIENT.SHOW_FOOD_DEBUG_INFO) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P) {
            FoodStats stats = mc.field_71439_g.func_71024_bL();
            float curExhaustion = HungerHelper.getExhaustion((EntityPlayer)mc.field_71439_g);
            float maxExhaustion = HungerHelper.getMaxExhaustion((EntityPlayer)mc.field_71439_g);
            textEvent.getLeft().add("hunger: " + stats.func_75116_a() + ", sat: " + saturationDF.format(stats.func_75115_e()) + ", exh: " + exhaustionValDF.format(curExhaustion) + "/" + exhaustionMaxDF.format(maxExhaustion));
        }
    }
}

