/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.client;

import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ua.myxazaur.lemonskin.LemonSkin;
import ua.myxazaur.lemonskin.ModConfig;
import ua.myxazaur.lemonskin.ModInfo;
import ua.myxazaur.lemonskin.helpers.AppleCoreHelper;
import ua.myxazaur.lemonskin.helpers.FoodHelper;
import ua.myxazaur.lemonskin.helpers.HealthHelper;
import ua.myxazaur.lemonskin.helpers.HungerHelper;

@SideOnly(value=Side.CLIENT)
public class HUDOverlayHandler {
    private float flashAlpha = 0.0f;
    private byte alphaDir = 1;
    protected int iconsOffset;
    private static int updateCounter;
    private static final ResourceLocation modIcons;
    private static final Field UCField;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new HUDOverlayHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreRender(RenderGameOverlayEvent.Pre event) {
        this.iconsOffset = GuiIngameForge.right_height;
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ScaledResolution scale = event.getResolution();
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
            if (!ModConfig.CLIENT.SHOW_FOOD_EXHAUSTION_UNDERLAY) {
                return;
            }
            int left = scale.func_78326_a() / 2 + 91;
            int top = scale.func_78328_b() - this.iconsOffset;
            HUDOverlayHandler.drawExhaustionOverlay(HungerHelper.getExhaustion((EntityPlayer)player), mc, left, top, 1.0f);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH || event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
            try {
                updateCounter = UCField.getInt(mc.field_71456_v);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ScaledResolution scale = event.getResolution();
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
            float heal;
            if (!this.shouldShowEstimatedHealth((EntityPlayer)mc.field_71439_g)) {
                return;
            }
            ItemStack held = player.func_184614_ca();
            if (!FoodHelper.isFood(held)) {
                held = player.func_184592_cb();
            }
            if (held.func_190926_b() || !FoodHelper.isFood(held)) {
                return;
            }
            FoodHelper.BasicFoodValues foodValues = FoodHelper.getModifiedFoodValues(held, (EntityPlayer)player);
            PotionEffect effect = FoodHelper.getEffect(held);
            if (held.func_77973_b() == Items.field_151153_ao) {
                if (held.func_77960_j() > 0) {
                    effect = new PotionEffect(MobEffects.field_76428_l, 400, 1);
                } else {
                    new PotionEffect(MobEffects.field_76428_l, 100, 1);
                }
            }
            if ((heal = HealthHelper.getEstimatedHealthIncrement((EntityPlayer)player, foodValues, effect)) <= 0.0f) {
                return;
            }
            float currentHealth = player.func_110143_aJ();
            float newHealth = Math.min(currentHealth + heal, player.func_110138_aP());
            int left = event.getResolution().func_78326_a() / 2 - 91;
            int top = event.getResolution().func_78328_b() - this.iconsOffset;
            HUDOverlayHandler.drawHealthOverlay(currentHealth, newHealth, mc, left, top, this.flashAlpha);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
            if (!ModConfig.CLIENT.SHOW_FOOD_VALUES_OVERLAY && !ModConfig.CLIENT.SHOW_SATURATION_OVERLAY) {
                return;
            }
            ItemStack heldItem = player.func_184614_ca();
            if (!FoodHelper.isFood(heldItem)) {
                heldItem = player.func_184592_cb();
            }
            FoodStats stats = player.func_71024_bL();
            int left = scale.func_78326_a() / 2 + 91;
            int top = scale.func_78328_b() - this.iconsOffset;
            if (ModConfig.CLIENT.SHOW_SATURATION_OVERLAY) {
                HUDOverlayHandler.drawSaturationOverlay(0.0f, stats.func_75115_e(), mc, left, top, 1.0f);
            }
            if (!ModConfig.CLIENT.SHOW_FOOD_VALUES_OVERLAY || heldItem.func_190926_b() || !FoodHelper.isFood(heldItem)) {
                this.flashAlpha = 0.0f;
                this.alphaDir = 1;
                return;
            }
            FoodHelper.BasicFoodValues foodValues = FoodHelper.getModifiedFoodValues(heldItem, (EntityPlayer)player);
            if (LemonSkin.hasAppleCore) {
                foodValues = AppleCoreHelper.getFoodValuesForDisplay(foodValues, (EntityPlayer)player);
            }
            HUDOverlayHandler.drawHungerOverlay(foodValues.hunger, stats.func_75116_a(), mc, left, top, this.flashAlpha, FoodHelper.isRotten(heldItem));
            if (ModConfig.CLIENT.SHOW_SATURATION_OVERLAY) {
                int newFoodValue = stats.func_75116_a() + foodValues.hunger;
                float newSaturationValue = stats.func_75115_e() + foodValues.getSaturationIncrement();
                HUDOverlayHandler.drawSaturationOverlay(newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.func_75115_e() : foodValues.getSaturationIncrement(), stats.func_75115_e(), mc, left, top, this.flashAlpha);
            }
        }
    }

    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, Minecraft mc, int left, int top, float alpha) {
        boolean shouldShake;
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        int startBar = saturationGained != 0.0f ? Math.max(0, (int)saturationLevel / 2) : 0;
        int endBar = (int)Math.ceil(Math.min(20.0f, saturationLevel + saturationGained) / 2.0f);
        int barsNeeded = endBar - startBar;
        mc.func_110434_K().func_110577_a(modIcons);
        Random localRand = new Random((long)updateCounter * 312871L);
        boolean bl = shouldShake = mc.field_71439_g.func_71024_bL().func_75115_e() <= 0.0f && updateCounter % (mc.field_71439_g.func_71024_bL().func_75116_a() * 3 + 1) == 0 && ModConfig.CLIENT.SHOW_VANILLA_ANIMATION_OVERLAY;
        if (shouldShake) {
            for (int j = 0; j < startBar; ++j) {
                localRand.nextInt(3);
            }
        }
        HUDOverlayHandler.enableAlpha(alpha);
        for (int i = startBar; i < startBar + barsNeeded; ++i) {
            float effectiveSaturationOfBar;
            int x = left - i * 8 - 9;
            int y = top;
            if (shouldShake) {
                y = top + (localRand.nextInt(3) - 1);
            }
            if ((effectiveSaturationOfBar = (saturationLevel + saturationGained) / 2.0f - (float)i) >= 1.0f) {
                mc.field_71456_v.func_73729_b(x, y, 27, 0, 9, 9);
                continue;
            }
            if ((double)effectiveSaturationOfBar > 0.5) {
                mc.field_71456_v.func_73729_b(x, y, 18, 0, 9, 9);
                continue;
            }
            if ((double)effectiveSaturationOfBar > 0.25) {
                mc.field_71456_v.func_73729_b(x, y, 9, 0, 9, 9);
                continue;
            }
            if (!(effectiveSaturationOfBar > 0.0f)) continue;
            mc.field_71456_v.func_73729_b(x, y, 0, 0, 9, 9);
        }
        HUDOverlayHandler.disableAlpha(alpha);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static void drawHungerOverlay(int hungerRestored, int foodLevel, Minecraft mc, int left, int top, float alpha, boolean isRotten) {
        boolean shouldShake;
        if (hungerRestored == 0) {
            return;
        }
        int startBar = foodLevel / 2;
        int endBar = (int)Math.ceil((float)Math.min(20, foodLevel + hungerRestored) / 2.0f);
        int barsNeeded = endBar - startBar;
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        HUDOverlayHandler.enableAlpha(alpha);
        Random localRand = new Random((long)updateCounter * 312871L);
        boolean bl = shouldShake = mc.field_71439_g.func_71024_bL().func_75115_e() <= 0.0f && updateCounter % (foodLevel * 3 + 1) == 0 && ModConfig.CLIENT.SHOW_VANILLA_ANIMATION_OVERLAY;
        if (shouldShake) {
            for (int j = 0; j < startBar; ++j) {
                localRand.nextInt(3);
            }
        }
        for (int i = startBar; i < startBar + barsNeeded; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 0;
            if (mc.field_71439_g.func_70644_a(MobEffects.field_76438_s) || isRotten) {
                icon += 36;
                background = 13;
            }
            if (shouldShake) {
                y = top + (localRand.nextInt(3) - 1);
            }
            mc.field_71456_v.func_73729_b(x, y, 16 + background * 9, 27, 9, 9);
            if (idx < foodLevel + hungerRestored) {
                mc.field_71456_v.func_73729_b(x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != foodLevel + hungerRestored) continue;
            mc.field_71456_v.func_73729_b(x, y, icon + 45, 27, 9, 9);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawHealthOverlay(float current, float modified, Minecraft mc, int left, int top, float alpha) {
        if (modified <= current) {
            return;
        }
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        EntityPlayerSP player = mc.field_71439_g;
        int healthTarget = MathHelper.func_76123_f((float)modified);
        boolean hardcore = mc.field_71441_e.func_72912_H().func_76093_s();
        int topOffset = hardcore ? 45 : 0;
        int margin = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            margin += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            margin += 72;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        int end = MathHelper.func_76123_f((float)(modified / 2.0f));
        int start = (int)current % 2 == 0 ? (int)(current / 2.0f) : (int)Math.floor(current / 2.0f);
        float healthMax = player.func_110138_aP();
        float absorb = player.func_110139_bj();
        int totalHearts = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f));
        boolean shouldShake = current <= 4.0f && ModConfig.CLIENT.SHOW_VANILLA_ANIMATION_OVERLAY;
        for (int i = start; i < end; ++i) {
            int row = i / 10;
            int x = left + i % 10 * 8;
            int y = top - row * 8;
            if (shouldShake) {
                Random rand = new Random((long)updateCounter * 312871L);
                int skips = totalHearts - 1 - i;
                for (int j = 0; j < skips; ++j) {
                    rand.nextInt(2);
                }
                y += rand.nextInt(2);
            }
            mc.field_71456_v.func_73729_b(x, y, 16, topOffset, 9, 9);
            boolean isHalf = i * 2 + 1 == healthTarget;
            int u = isHalf ? margin + 45 : margin + 36;
            mc.field_71456_v.func_73729_b(x, y, u, topOffset, 9, 9);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawExhaustionOverlay(float exhaustion, Minecraft mc, int left, int top, float alpha) {
        mc.func_110434_K().func_110577_a(modIcons);
        float maxExhaustion = HungerHelper.getMaxExhaustion((EntityPlayer)mc.field_71439_g);
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        mc.field_71456_v.func_73729_b(left - width, top, 81 - width, 18, width, height);
        HUDOverlayHandler.disableAlpha(0.75f);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    private boolean shouldShowEstimatedHealth(EntityPlayer player) {
        if (!ModConfig.CLIENT.SHOW_FOOD_HEALTH_HUD_OVERLAY) {
            return false;
        }
        if (player.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        FoodStats stats = player.func_71024_bL();
        if (stats.func_75116_a() >= 18) {
            return false;
        }
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            return false;
        }
        if (player.func_70644_a(MobEffects.field_82731_v)) {
            return false;
        }
        return !player.func_70644_a(MobEffects.field_76428_l);
    }

    public static void enableAlpha(float alpha) {
        GlStateManager.func_179147_l();
        if (alpha == 1.0f) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public static void disableAlpha(float alpha) {
        GlStateManager.func_179084_k();
        if (alpha == 1.0f) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.flashAlpha += (float)this.alphaDir * 0.125f;
        if (this.flashAlpha >= 1.5f) {
            this.flashAlpha = 1.0f;
            this.alphaDir = (byte)-1;
        } else if (this.flashAlpha <= -0.5f) {
            this.flashAlpha = 0.0f;
            this.alphaDir = 1;
        }
    }

    static {
        modIcons = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");
        UCField = ReflectionHelper.findField(GuiIngame.class, (String)"updateCounter", (String)"field_73837_f");
    }
}

