/*
 * Decompiled with CFR 0.152.
 */
package com.noodlegamer76.shadered.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SkyBoxRenderer {
    public static void renderBlockSkybox(PoseStack poseStack, int ticks, float partialTick, int alpha, float speed, ResourceLocation frontTexture, ResourceLocation backTexture, ResourceLocation leftTexture, ResourceLocation rightTexture, ResourceLocation topTexture, ResourceLocation bottomTexture) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Quaternionf quaternionf = new Quaternionf((Quaternionfc)camera.rotation()).invert();
        for (int i = 0; i < 6; ++i) {
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            poseStack.pushPose();
            poseStack.mulPose(Axis.YN.rotationDegrees(((float)ticks + partialTick) * speed));
            poseStack.mulPose(quaternionf);
            if (i == 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)frontTexture);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
                poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
            }
            if (i == 1) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)rightTexture);
                poseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.YN.rotationDegrees(-90.0f));
            }
            if (i == 2) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)leftTexture);
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
                poseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
            }
            if (i == 3) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)backTexture);
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
            }
            if (i == 4) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)bottomTexture);
                poseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
                poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
            }
            if (i == 5) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)topTexture);
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
                poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
            }
            float far = Minecraft.getInstance().gameRenderer.getRenderDistance();
            Matrix4f matrix4f = poseStack.last().pose();
            bufferBuilder.addVertex(matrix4f, -far, -far, -far).setUv(0.0f, 0.0f);
            bufferBuilder.addVertex(matrix4f, -far, -far, far).setUv(0.0f, 1.0f);
            bufferBuilder.addVertex(matrix4f, far, -far, far).setUv(1.0f, 1.0f);
            bufferBuilder.addVertex(matrix4f, far, -far, -far).setUv(1.0f, 0.0f);
            poseStack.popPose();
            MeshData data = bufferBuilder.build();
            if (data == null) continue;
            BufferUploader.drawWithShader((MeshData)data);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void renderEndSky(PoseStack pPoseStack) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TheEndPortalRenderer.END_SKY_LOCATION);
        Quaternionf rotation = new Quaternionf((Quaternionfc)Minecraft.getInstance().gameRenderer.getMainCamera().rotation()).invert();
        for (int i = 0; i < 6; ++i) {
            pPoseStack.pushPose();
            pPoseStack.mulPose(rotation);
            if (i == 1) {
                pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            if (i == 2) {
                pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            }
            if (i == 3) {
                pPoseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            }
            if (i == 4) {
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            if (i == 5) {
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            }
            Matrix4f matrix4f = pPoseStack.last().pose();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(-14145496);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            pPoseStack.popPose();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void renderBlockSkybox(PoseStack poseStack, ResourceLocation folder) {
        SkyBoxRenderer.renderBlockSkybox(poseStack, 0, 0.0f, 255, 0.0f, folder.withSuffix("/front.png"), folder.withSuffix("/back.png"), folder.withSuffix("/left.png"), folder.withSuffix("/right.png"), folder.withSuffix("/top.png"), folder.withSuffix("/bottom.png"));
    }
}

