/*
 * Decompiled with CFR 0.152.
 */
package com.noodlegamer76.shadered.event;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.noodlegamer76.shadered.client.util.GlUtils;
import com.noodlegamer76.shadered.client.util.RenderCube;
import com.noodlegamer76.shadered.client.util.RenderCubeAroundPlayer;
import com.noodlegamer76.shadered.client.util.SkyBoxRenderer;
import com.noodlegamer76.shadered.event.RegisterShadersEvent;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="shadered", value={Dist.CLIENT})
public class RenderEventsForFbos {
    public static final ResourceLocation NEBULA = new ResourceLocation("shadered", "textures/environment/nebula");
    public static final ResourceLocation STORMY = new ResourceLocation("shadered", "textures/environment/stormy");
    public static final ResourceLocation OCEAN = new ResourceLocation("shadered", "textures/environment/ocean");
    public static final ResourceLocation ECLIPSE = new ResourceLocation("shadered", "textures/environment/eclipse");
    private static boolean fboSetup = false;
    public static TextureTarget nebulaTarget;
    public static TextureTarget stormyTarget;
    public static TextureTarget oceanTarget;
    public static TextureTarget endSkyTarget;
    public static TextureTarget eclipseTarget;
    public static TextureTarget skyboxTarget;
    public static int width;
    public static int height;
    public static int previousSizeX;
    public static int previousSizeY;
    public static ArrayList<BlockPos> spacePositions;
    public static ArrayList<BlockPos> stormyPositions;
    public static ArrayList<BlockPos> oceanPositions;
    public static ArrayList<BlockPos> endPositions;
    public static ArrayList<BlockPos> endSkyPositions;
    public static ArrayList<BlockPos> eclipsePositions;
    public static ArrayList<Matrix4f> spacePose;
    public static ArrayList<Matrix4f> stormyPose;
    public static ArrayList<Matrix4f> oceanPose;
    public static ArrayList<Matrix4f> endPose;
    public static ArrayList<Matrix4f> endSkyPose;
    public static ArrayList<Matrix4f> eclipsePose;

    @SubscribeEvent
    public static void levelRenderEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY && !fboSetup) {
            width = Minecraft.m_91087_().m_91268_().m_85441_();
            height = Minecraft.m_91087_().m_91268_().m_85442_();
            nebulaTarget = new TextureTarget(width, height, true, true);
            stormyTarget = new TextureTarget(width, height, true, true);
            oceanTarget = new TextureTarget(width, height, true, true);
            endSkyTarget = new TextureTarget(width, height, true, true);
            eclipseTarget = new TextureTarget(width, height, true, true);
            skyboxTarget = new TextureTarget(width, height, false, true);
            previousSizeX = width;
            previousSizeY = height;
            fboSetup = true;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            width = Minecraft.m_91087_().m_91268_().m_85441_();
            height = Minecraft.m_91087_().m_91268_().m_85442_();
            nebulaTarget.m_83954_(true);
            stormyTarget.m_83954_(true);
            oceanTarget.m_83954_(true);
            endSkyTarget.m_83954_(true);
            eclipseTarget.m_83954_(true);
            skyboxTarget.m_83954_(true);
            if (width != previousSizeX || height != previousSizeY) {
                nebulaTarget.m_83941_(width, height, true);
                stormyTarget.m_83941_(width, height, true);
                oceanTarget.m_83941_(width, height, true);
                endSkyTarget.m_83941_(width, height, true);
                eclipseTarget.m_83941_(width, height, true);
                skyboxTarget.m_83941_(width, height, true);
            }
            Minecraft.m_91087_().m_91385_().m_83947_(true);
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            Minecraft mc = Minecraft.m_91087_();
            RenderTarget mainTarget = mc.m_91385_();
            nebulaTarget.m_83947_(true);
            RenderEventsForFbos.renderBlockEntities(event.getPartialTick(), spacePositions, spacePose);
            skyboxTarget.m_83947_(true);
            SkyBoxRenderer.renderBlockSkybox(event.getPoseStack(), NEBULA);
            GlUtils.copyColorFrom((RenderTarget)nebulaTarget, (RenderTarget)skyboxTarget);
            nebulaTarget.m_83947_(true);
            RenderEventsForFbos.renderWithoutInfiniteDepth(nebulaTarget, event.getPoseStack());
            stormyTarget.m_83947_(true);
            RenderEventsForFbos.renderBlockEntities(event.getPartialTick(), stormyPositions, stormyPose);
            skyboxTarget.m_83947_(true);
            SkyBoxRenderer.renderBlockSkybox(event.getPoseStack(), STORMY);
            GlUtils.copyColorFrom((RenderTarget)stormyTarget, (RenderTarget)skyboxTarget);
            stormyTarget.m_83947_(true);
            RenderEventsForFbos.renderWithoutInfiniteDepth(stormyTarget, event.getPoseStack());
            oceanTarget.m_83947_(true);
            RenderEventsForFbos.renderBlockEntities(event.getPartialTick(), oceanPositions, oceanPose);
            skyboxTarget.m_83947_(true);
            SkyBoxRenderer.renderBlockSkybox(event.getPoseStack(), OCEAN);
            GlUtils.copyColorFrom((RenderTarget)oceanTarget, (RenderTarget)skyboxTarget);
            oceanTarget.m_83947_(true);
            RenderEventsForFbos.renderWithoutInfiniteDepth(oceanTarget, event.getPoseStack());
            eclipseTarget.m_83947_(true);
            RenderEventsForFbos.renderBlockEntities(event.getPartialTick(), eclipsePositions, eclipsePose);
            skyboxTarget.m_83947_(true);
            SkyBoxRenderer.renderBlockSkybox(event.getPoseStack(), ECLIPSE);
            GlUtils.copyColorFrom((RenderTarget)eclipseTarget, (RenderTarget)skyboxTarget);
            eclipseTarget.m_83947_(true);
            RenderEventsForFbos.renderWithoutInfiniteDepth(eclipseTarget, event.getPoseStack());
            endSkyTarget.m_83947_(true);
            RenderEventsForFbos.renderBlockEntities(event.getPartialTick(), endSkyPositions, endSkyPose);
            skyboxTarget.m_83947_(true);
            SkyBoxRenderer.renderEndSky(event.getPoseStack());
            GlUtils.copyColorFrom((RenderTarget)endSkyTarget, (RenderTarget)skyboxTarget);
            endSkyTarget.m_83947_(true);
            RenderEventsForFbos.renderWithoutInfiniteDepth(endSkyTarget, event.getPoseStack());
            mainTarget.m_83947_(true);
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().ortho(-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f), (VertexSorting)VertexSorting.f_276633_);
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_166856_();
            RenderEventsForFbos.render(poseStack, (RenderTarget)nebulaTarget);
            RenderEventsForFbos.render(poseStack, (RenderTarget)stormyTarget);
            RenderEventsForFbos.render(poseStack, (RenderTarget)oceanTarget);
            RenderEventsForFbos.render(poseStack, (RenderTarget)eclipseTarget);
            RenderEventsForFbos.render(poseStack, (RenderTarget)endSkyTarget);
            poseStack.m_85849_();
            RenderSystem.restoreProjectionMatrix();
            RenderCube.renderCubeWithRenderType(endPositions, event.getPartialTick(), RenderType.m_173239_(), endPose);
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            previousSizeY = height;
            previousSizeX = width;
        }
    }

    public static void renderWithoutInfiniteDepth(TextureTarget target, PoseStack poseStack) {
        RenderSystem.setShader(() -> RegisterShadersEvent.depthDiscarder);
        RegisterShadersEvent.depthDiscarder.m_173350_("Skybox", (Object)target.m_83975_());
        RegisterShadersEvent.depthDiscarder.m_173350_("SkyboxDepth", (Object)target.m_83980_());
        RegisterShadersEvent.depthDiscarder.m_173350_("MainDepth", (Object)Minecraft.m_91087_().m_91385_().m_83980_());
        RenderCubeAroundPlayer.renderCubeWithShader(poseStack);
        Minecraft.m_91087_().m_91385_().m_83945_((RenderTarget)target);
    }

    public static void render(PoseStack poseStack, RenderTarget target) {
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)target.m_83975_());
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -1.0f, 1.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, 1.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, -1.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -1.0f, -1.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    public static void renderBlockEntities(float partialTick, ArrayList<BlockPos> positions, ArrayList<Matrix4f> poses) {
        if (positions.size() != poses.size()) {
            return;
        }
        RenderCube.renderSkyBlocks(positions, partialTick, poses, GameRenderer.m_172811_());
    }

    static {
        spacePositions = new ArrayList();
        stormyPositions = new ArrayList();
        oceanPositions = new ArrayList();
        endPositions = new ArrayList();
        endSkyPositions = new ArrayList();
        eclipsePositions = new ArrayList();
        spacePose = new ArrayList();
        stormyPose = new ArrayList();
        oceanPose = new ArrayList();
        endPose = new ArrayList();
        endSkyPose = new ArrayList();
        eclipsePose = new ArrayList();
    }
}

