/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.ahCopycoords;

import de.meisterah.ahCopycoords.config.AhCopyCoordsConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_370;
import net.minecraft.class_374;
import org.lwjgl.glfw.GLFW;

public class AhCopyCoords
implements ClientModInitializer {
    private static class_304 keyBindingCopy;
    private static class_304 keyBindingDimension;
    private int messageTimer = 0;
    private String lastCoordinates = "";
    private boolean showingMessage = false;
    public static AhCopyCoordsConfig CONFIG;
    private Dimension currentDimension = Dimension.OVERWORLD;
    private Dimension playerActualDimension = Dimension.OVERWORLD;

    public void onInitializeClient() {
        CONFIG = AhCopyCoordsConfig.load();
        keyBindingCopy = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.ahcopycoords.copy", class_3675.class_307.field_1668, 341, "category.ahcopycoords.general"));
        keyBindingDimension = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.ahcopycoords.dimension", class_3675.class_307.field_1668, 78, "category.ahcopycoords.general"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                if (client.field_1687 != null) {
                    this.playerActualDimension = client.field_1687.method_27983().method_29177().method_12832().contains("nether") ? Dimension.NETHER : (client.field_1687.method_27983().method_29177().method_12832().contains("end") ? Dimension.END : Dimension.OVERWORLD);
                }
                if (keyBindingDimension.method_1436()) {
                    this.cycleDimension();
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)this.currentDimension.getDimensionMessage()), true);
                }
                if (keyBindingCopy.method_1436()) {
                    double x = client.field_1724.method_23317();
                    double y = client.field_1724.method_23318();
                    double z = client.field_1724.method_23321();
                    int blockX = (int)Math.floor(x);
                    int blockY = (int)Math.floor(y);
                    int blockZ = (int)Math.floor(z);
                    int[] convertedCoords = this.convertCoordinates(blockX, blockY, blockZ, this.playerActualDimension, this.currentDimension);
                    this.lastCoordinates = CONFIG.formatCoordinates(convertedCoords[0], convertedCoords[1], convertedCoords[2]);
                    boolean success = this.copyToClipboardGLFW(this.lastCoordinates, client.method_22683().method_4490());
                    if (success) {
                        this.showToast(client, this.currentDimension.getName() + " Coords copied", this.lastCoordinates);
                    } else {
                        this.showToast(client, "Fehler beim Kopieren", "Konnte Koordinaten nicht kopieren");
                    }
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a" + this.currentDimension.getName() + " Coords copied: \u00a7f" + this.lastCoordinates)), false);
                    this.messageTimer = 60;
                    this.showingMessage = true;
                }
                if (this.showingMessage && this.messageTimer > 0) {
                    --this.messageTimer;
                    if (this.messageTimer <= 0) {
                        this.showingMessage = false;
                    }
                }
            }
        });
    }

    private void cycleDimension() {
        switch (this.currentDimension.ordinal()) {
            case 0: {
                this.currentDimension = Dimension.NETHER;
                break;
            }
            case 1: {
                this.currentDimension = Dimension.END;
                break;
            }
            case 2: {
                this.currentDimension = Dimension.OVERWORLD;
            }
        }
    }

    private int[] convertCoordinates(int x, int y, int z, Dimension fromDimension, Dimension toDimension) {
        int[] converted = new int[3];
        int[] overworldCoords = new int[3];
        switch (fromDimension.ordinal()) {
            case 0: {
                overworldCoords[0] = x;
                overworldCoords[1] = y;
                overworldCoords[2] = z;
                break;
            }
            case 1: {
                overworldCoords[0] = x * 8;
                overworldCoords[1] = y;
                overworldCoords[2] = z * 8;
                break;
            }
            case 2: {
                overworldCoords[0] = x;
                overworldCoords[1] = y;
                overworldCoords[2] = z;
            }
        }
        switch (toDimension.ordinal()) {
            case 0: {
                converted[0] = overworldCoords[0];
                converted[1] = overworldCoords[1];
                converted[2] = overworldCoords[2];
                break;
            }
            case 1: {
                converted[0] = overworldCoords[0] / 8;
                converted[1] = overworldCoords[1];
                converted[2] = overworldCoords[2] / 8;
                break;
            }
            case 2: {
                converted[0] = overworldCoords[0];
                converted[1] = overworldCoords[1];
                converted[2] = overworldCoords[2];
            }
        }
        return converted;
    }

    private void showToast(class_310 client, String title, String description) {
        class_370.method_1990((class_374)client.method_1566(), (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_43470((String)title), (class_2561)class_2561.method_43470((String)description));
    }

    private boolean copyToClipboardGLFW(String text, long windowHandle) {
        try {
            GLFW.glfwSetClipboardString((long)windowHandle, (CharSequence)text);
            return true;
        }
        catch (Exception e) {
            System.err.println("GLFW Clipboard error: " + e.getMessage());
            try {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("mac")) {
                    ProcessBuilder pb = new ProcessBuilder("bash", "-c", "echo' " + text + "' | pbcopy");
                    Process process = pb.start();
                    int exitCode = process.waitFor();
                    return exitCode == 0;
                }
                if (os.contains("win")) {
                    ProcessBuilder pb = new ProcessBuilder("cmd", "/c", "echo " + text + " | clip");
                    Process process = pb.start();
                    int exitCode = process.waitFor();
                    return exitCode == 0;
                }
            }
            catch (Exception ex) {
                System.err.println("Native clipboard fallback error: " + ex.getMessage());
            }
            return false;
        }
    }

    private static enum Dimension {
        OVERWORLD("Overworld", "\u00a7a\u00a7l", "\u00a7a"),
        NETHER("Nether", "\u00a7c\u00a7l", "\u00a7c"),
        END("End", "\u00a7d\u00a7l", "\u00a7d");

        private final String name;
        private final String colorCode;
        private final String lightColorCode;

        private Dimension(String name, String colorCode, String lightColorCode) {
            this.name = name;
            this.colorCode = colorCode;
            this.lightColorCode = lightColorCode;
        }

        public String getName() {
            return this.name;
        }

        public String getColoredName() {
            return this.colorCode + this.name + "\u00a7r";
        }

        public String getDimensionMessage() {
            return "\u00a7eCurrent Dimension: \u00a7r" + this.getColoredName();
        }
    }
}

