/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.ahCopycoords.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class AhCopyCoordsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("ahcopycoords.json").toFile();
    private String coordinateFormat = "%x %y %z";

    public static AhCopyCoordsConfig load() {
        AhCopyCoordsConfig config = new AhCopyCoordsConfig();
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (AhCopyCoordsConfig)GSON.fromJson((Reader)reader, AhCopyCoordsConfig.class);
            }
            catch (IOException e) {
                System.err.println("Error while Loading the AH-CopyCoordsConfig: " + e.getMessage());
            }
        } else {
            config.save();
        }
        return config;
    }

    public void save() {
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Error while saving the AH-CopyCoordsConfig: " + e.getMessage());
        }
    }

    public String getCoordinateFormat() {
        return this.coordinateFormat;
    }

    public void setCoordinateFormat(String coordinateFormat) {
        this.coordinateFormat = coordinateFormat;
        this.save();
    }

    public String formatCoordinates(int x, int y, int z) {
        return this.coordinateFormat.replace("%x", String.valueOf(x)).replace("%y", String.valueOf(y)).replace("%z", String.valueOf(z));
    }
}

