/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.client;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.client.guiparticle.PendingEffect;
import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.logic.HeartContainer;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HeartRenderer
extends Gui {
    public List<HeartContainer> containers = Lists.newArrayList();
    public static final int TEXTURE_WIDTH = 256;
    public static final int TEXTURE_HEIGHT = 256;
    public List<PendingEffect> pendingEffects = Lists.newArrayList();
    private int healthUpdateCounter;
    private int updateCounter;
    private long lastSystemTime;
    private Random rand = new Random(0L);
    private boolean useMoreSpace;
    public float decay = 0.0f;

    public void setUseMoreSpace(boolean useMoreSpace) {
        this.useMoreSpace = useMoreSpace;
    }

    public boolean useMoreSpace() {
        return this.useMoreSpace;
    }

    public void tick() {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            ++this.updateCounter;
            for (HeartContainer hc : this.containers) {
                if (hc == null) continue;
                ++hc.animationTicks;
            }
        }
    }

    public void renderHealth(ScaledResolution res, float partialTicks) {
        int y;
        int x;
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_76320_a("glasshearts:healthbar");
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        EntityPlayer player = (EntityPlayer)mc.func_175606_aa();
        boolean highlight = (long)this.healthUpdateCounter > (long)this.updateCounter && ((long)this.healthUpdateCounter - (long)this.updateCounter) / 3L % 2L == 1L;
        boolean anyNotEqual = false;
        boolean loss = false;
        for (HeartContainer hc : this.containers) {
            if (hc == null || hc.getLastFillAmount() == hc.getFillAmount()) continue;
            anyNotEqual = true;
            if (!(hc.getLastFillAmount() > hc.getFillAmount())) break;
            loss = true;
            break;
        }
        if (anyNotEqual && player.field_70172_ad > 0 && this.healthUpdateCounter - this.updateCounter < 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = this.updateCounter + (loss ? 20 : 10);
        }
        if (Minecraft.func_71386_F() - this.lastSystemTime > 1000L) {
            this.lastSystemTime = Minecraft.func_71386_F();
            for (HeartContainer hc : this.containers) {
                if (hc == null) continue;
                hc.setLastFillAmount(hc.getFillAmount());
            }
        }
        float absorb = player.func_110139_bj() / 2.0f;
        int absorbTotal = MathHelper.func_76123_f((float)absorb);
        int totalHearts = this.containers.size() + absorbTotal;
        int healthRows = MathHelper.func_76123_f((float)((float)totalHearts / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed((long)this.updateCounter * 312871L);
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        GuiIngameForge.left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            GuiIngameForge.left_height += 10 - rowHeight;
        }
        float regen = -1.0f;
        if (player.func_70644_a(MobEffects.field_76428_l)) {
            regen = ((float)this.updateCounter + partialTicks) % (float)(totalHearts + 15);
        }
        for (PendingEffect pe : this.pendingEffects) {
            int index = pe.getIndex();
            x = left;
            y = top;
            int diff = MathHelper.func_76123_f((float)((float)(index + 1) / 10.0f)) - MathHelper.func_76123_f((float)((float)Math.min(10, totalHearts) / 10.0f));
            pe.getEffect().spawn(x += index % 10 * 8, y -= diff * rowHeight);
        }
        this.pendingEffects.clear();
        boolean shake = player.func_110143_aJ() <= player.func_110138_aP() / 5.0f;
        int defaultX = left + (totalHearts + 9) % 10 * 8;
        int defaultY = top - (healthRows - 1) * rowHeight;
        x = defaultX;
        y = defaultY;
        for (int i = totalHearts - 1; i >= 0; --i) {
            float alpha;
            float nextAlpha;
            int uOffset;
            float fill;
            HeartContainer hc = i >= this.containers.size() ? null : this.containers.get(i);
            GlStateManager.func_179094_E();
            if (hc == null) {
                fill = i == totalHearts - 1 ? ((float)((int)absorb) == absorb ? 1.0f : absorb % 1.0f) : 1.0f;
                uOffset = -1;
                nextAlpha = 0.0f;
                alpha = 1.0f;
            } else {
                fill = hc.getFillAmount();
                if (hc.getGlassColor() == null) {
                    uOffset = (int)this.decay;
                    nextAlpha = this.decay % 1.0f;
                    alpha = 1.0f;
                } else {
                    uOffset = 0;
                    nextAlpha = 0.0f;
                    float anim = (float)hc.animationTicks + partialTicks;
                    if (anim < 25.0f) {
                        float sin;
                        fill = 0.0f;
                        alpha = sin = MathHelper.func_76126_a((float)(anim / 25.0f * 1.5707964f));
                        if (anim < 15.0f) {
                            float sin2 = MathHelper.func_76126_a((float)(anim / 15.0f * 1.5707964f));
                            GlStateManager.func_179109_b((float)0.0f, (float)((1.0f - sin2) * -9.0f), (float)0.0f);
                        }
                    } else if (anim < 30.0f) {
                        alpha = 1.0f;
                        float sin = MathHelper.func_76126_a((float)((anim - 25.0f) / 5.0f * 1.5707964f));
                        fill *= sin;
                    } else {
                        alpha = 1.0f;
                    }
                }
            }
            int oldY = y;
            if (shake) {
                y += this.rand.nextInt(2);
            }
            if (regen != -1.0f) {
                float r = regen - (float)i;
                if (r >= 0.0f && r <= 1.0f) {
                    y = (int)((float)y - 2.0f * (r % 1.0f));
                } else if (r > 1.0f && r < 2.0f) {
                    y = (int)((float)y - 2.0f * (1.0f - r % 1.0f));
                }
            }
            mc.func_110434_K().func_110577_a(GlassHearts.TEX);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int bgFgIdx = hc == null || hc.getGlassColor() == null ? 0 : (hc.getGlassColor() == EnumGlassColor.NONE ? 1 : 2);
            HeartRenderer.func_146110_a((int)x, (int)y, (float)(9 + bgFgIdx * 18), (float)27.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
            if (highlight) {
                HeartRenderer.func_146110_a((int)x, (int)y, (float)(18 + bgFgIdx * 18), (float)27.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
            }
            int fillIdx = player.func_70644_a(MobEffects.field_82731_v) ? 2 : (player.func_70644_a(MobEffects.field_76436_u) ? 1 : 0);
            if (hc != null && highlight) {
                HeartRenderer.drawModalRectWithCustomSizedTexture(x, y, 36 + uOffset * 9, 72 + (fillIdx * 18 + 9), hc.getLastFillAmount() * 9.0f, 9.0f, 256.0f, 256.0f);
                if (nextAlpha > 0.0f) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(nextAlpha * alpha));
                    HeartRenderer.drawModalRectWithCustomSizedTexture(x, y, 36 + (uOffset + 1) * 9, 72 + (fillIdx * 18 + 9), hc.getLastFillAmount() * 9.0f, 9.0f, 256.0f, 256.0f);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                }
            }
            HeartRenderer.drawModalRectWithCustomSizedTexture(x, y, 36 + uOffset * 9, 72 + fillIdx * 18, fill * 9.0f, 9.0f, 256.0f, 256.0f);
            if (nextAlpha > 0.0f) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(nextAlpha * alpha));
                HeartRenderer.drawModalRectWithCustomSizedTexture(x, y, 36 + (uOffset + 1) * 9, 72 + fillIdx * 18, fill * 9.0f, 9.0f, 256.0f, 256.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }
            if (hc != null && hc.getGlassColor() == null) {
                HeartRenderer.drawModalRectWithCustomSizedTexture(x, y, 18.0f, 72 + fillIdx * 18, fill * 9.0f, 9.0f, 256.0f, 256.0f);
            }
            if (hc != null && hc.getGlassColor() != null && hc.getGlassColor().dye != null) {
                float[] fleece = EntitySheep.func_175513_a((EnumDyeColor)hc.getGlassColor().dye);
                GlStateManager.func_179131_c((float)fleece[0], (float)fleece[1], (float)fleece[2], (float)alpha);
            }
            float ofsL = 0.5f;
            float ofsR = 0.5f;
            if (x - 8 < left) {
                ofsL = 0.0f;
            } else if (x == left + 72 || y == defaultY && x == defaultX) {
                ofsR = 0.0f;
            }
            HeartRenderer.drawModalRectWithCustomSizedTexture((float)x + ofsL, y, 9.0f + ofsL + (float)(bgFgIdx * 18), 36.0f, 9.0f - (ofsL + ofsR), 9.0f, 256.0f, 256.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (highlight) {
                HeartRenderer.drawModalRectWithCustomSizedTexture((float)x + ofsL, y, 18.0f + ofsL + (float)(bgFgIdx * 18), 36.0f, 9.0f - (ofsL + ofsR), 9.0f, 256.0f, 256.0f);
            }
            if (mc.field_71441_e.func_72912_H().func_76093_s() && hc != null && hc.getGlassColor() == null) {
                HeartRenderer.drawModalRectWithCustomSizedTexture(x, y, 9.0f, 72 + (fillIdx * 18 + (highlight ? 9 : 0)), fill * 9.0f, 9.0f, 256.0f, 256.0f);
            }
            if (hc != null) {
                boolean bind;
                Gem gem = hc.getGem();
                boolean bl = bind = !gem.getTexture().equals((Object)GlassHearts.TEX);
                if (bind) {
                    mc.func_110434_K().func_110577_a(gem.getTexture());
                }
                HeartRenderer.drawModalRect(x, y, 9.0f, 9.0f, gem.getMinU(), gem.getMinV(), gem.getMaxU(), gem.getMaxV());
                if (bind) {
                    mc.func_110434_K().func_110577_a(GlassHearts.TEX);
                }
            }
            GlStateManager.func_179121_F();
            y = oldY;
            if ((x -= 8) >= left) continue;
            x = left + 72;
            y += rowHeight;
        }
        if (mc.field_71474_y.field_74330_P && !mc.func_189648_am()) {
            String a = Float.toString(player.func_110143_aJ() / 2.0f);
            mc.field_71466_p.func_78276_b(a, left - 2 - mc.field_71466_p.func_78256_a(a), y - 9, -65536);
            String b = Float.toString(absorb);
            mc.field_71466_p.func_78276_b(b, left - 2 - mc.field_71466_p.func_78256_a(b), top - 10, -256);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        mc.field_71424_I.func_76319_b();
    }

    public static void drawModalRectWithCustomSizedTexture(float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        float xScale = 1.0f / textureWidth;
        float yScale = 1.0f / textureHeight;
        HeartRenderer.drawModalRect(x, y, width, height, u * xScale, v * yScale, (u + width) * xScale, (v + height) * yScale);
    }

    public static void drawModalRect(float x, float y, float width, float height, float minU, float minV, float maxU, float maxV) {
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        vb.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        vb.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        vb.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        tess.func_78381_a();
    }
}

