/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.client;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.block.BlockGlassHeart;
import com.elytradev.glasshearts.enums.EnumGemState;
import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;

public class RenderGlassHeart
extends TileEntitySpecialRenderer<TileEntityGlassHeart> {
    public static float getAnimTime(TileEntityGlassHeart te, float partialTicks) {
        return (float)((te.func_145831_w().func_82737_E() + (long)te.hashCode()) % 24000L) + partialTicks;
    }

    public void renderTileEntityAt(TileEntityGlassHeart te, double x, double y, double z, float partialTicks, int destroyStage) {
        super.func_180535_a((TileEntity)te, x, y, z, partialTicks, destroyStage);
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        BlockModelRenderer bmr = brd.func_175019_b();
        boolean stained = te.getColor() != EnumGlassColor.NONE;
        IBlockState outerState = GlassHearts.inst.GLASS_HEART.func_176223_P().func_177226_a((IProperty)BlockGlassHeart.INNER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockGlassHeart.STAINED, (Comparable)Boolean.valueOf(stained));
        IBakedModel outer = brd.func_184389_a(outerState);
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        float t = RenderGlassHeart.getAnimTime(te, partialTicks);
        GlStateManager.func_179109_b((float)0.5f, (float)(0.5f + MathHelper.func_76126_a((float)(t / 12.0f)) / 16.0f), (float)0.5f);
        GlStateManager.func_179114_b((float)(t % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179084_k();
        if (MinecraftForgeClient.getRenderPass() == 0) {
            float partial;
            float f = partial = te.getLifeforceBuffer() > 0 ? partialTicks * (float)te.getGem().adjustFillRate(GlassHearts.inst.configGlassHeartFillRate) : 0.0f;
            if (te.getGem() == Gems.OPAL && te.getGem().getState(te) != EnumGemState.INACTIVE) {
                partial = ((float)te.func_145831_w().func_82737_E() + partialTicks) % 10.0f / 10.0f;
            }
            float amt = ((float)te.getLifeforce() + partial) / (float)te.getLifeforceCapacity() * 12.0f;
            float bufferAmt = (float)te.getLifeforceBuffer() / (float)te.getLifeforceCapacity() * 12.0f;
            this.renderFill(amt);
            if (bufferAmt > 0.0f) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179152_a((float)0.99f, (float)0.99f, (float)0.99f);
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                this.renderFill(bufferAmt + amt);
                GlStateManager.func_179121_F();
            }
        }
        if (MinecraftForgeClient.getRenderPass() == 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            GlStateManager.func_179109_b((float)0.5f, (float)0.55f, (float)0.5f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.265f);
            GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(te.getGemStack(), ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.265f);
            GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(te.getGemStack(), ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
        if (stained) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        } else {
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }
        if (stained && MinecraftForgeClient.getRenderPass() == 1) {
            float[] color = EntitySheep.func_175513_a((EnumDyeColor)te.getColor().dye);
            bmr.func_187495_a(outerState, outer, 1.0f, color[0], color[1], color[2]);
        } else if (MinecraftForgeClient.getRenderPass() == 0) {
            bmr.func_187495_a(outerState, outer, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        GlStateManager.func_179121_F();
    }

    private void renderFill(float amt) {
        float veryBottomElement = Math.min(amt, 2.0f);
        float bottomElement = Math.max(0.0f, Math.min(amt - 2.0f, 2.0f));
        float midElement = Math.max(0.0f, Math.min(amt - 4.0f, 6.0f));
        float topElement = Math.max(0.0f, Math.min(amt - 10.0f, 2.0f));
        TextureAtlasSprite tas = Minecraft.func_71410_x().func_147117_R().func_110572_b("glasshearts:blocks/lifeforce_still");
        if (veryBottomElement > 0.0f) {
            this.renderCube(6, 2, 6, 4.0f, veryBottomElement, 4.0f, tas, bottomElement <= 0.0f, true, true);
        }
        if (bottomElement > 0.0f) {
            this.renderCube(4, 4, 6, 8.0f, bottomElement, 4.0f, tas, midElement <= 0.0f, false, true);
            this.renderCube(4, 4, 6, 2.0f, 0.0f, 4.0f, tas, false, true, false);
            this.renderCube(10, 4, 6, 2.0f, 0.0f, 4.0f, tas, false, true, false);
        }
        if (midElement > 0.0f) {
            this.renderCube(2, 6, 6, 12.0f, midElement, 4.0f, tas, topElement <= 0.0f, false, true);
            this.renderCube(2, 6, 6, 2.0f, 0.0f, 4.0f, tas, false, true, false);
            this.renderCube(12, 6, 6, 2.0f, 0.0f, 4.0f, tas, false, true, false);
        }
        if (topElement > 0.0f) {
            this.renderCube(2, 12, 6, 5.0f, topElement, 4.0f, tas, true, false, true);
            this.renderCube(7, 12, 6, 2.0f, 0.0f, 4.0f, tas, true, false, false);
            this.renderCube(9, 12, 6, 5.0f, topElement, 4.0f, tas, true, false, true);
        }
    }

    private void renderCube(int x, int y, int z, float w, float h, float d, TextureAtlasSprite tas, boolean renderTop, boolean renderBottom, boolean renderSides) {
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer vb = tess.func_178180_c();
        float minVX = tas.func_94207_b((double)x);
        float maxVX = tas.func_94207_b((double)((float)x + w));
        float minVY = tas.func_94207_b((double)y);
        float maxVY = tas.func_94207_b((double)((float)y + h));
        float minUX = tas.func_94214_a((double)x);
        float maxUX = tas.func_94214_a((double)((float)x + w));
        float minUZ = tas.func_94214_a((double)z);
        float maxUZ = tas.func_94214_a((double)((float)z + d));
        float s = 0.0625f;
        vb.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        if (renderSides) {
            vb.func_181662_b((double)((float)(x + 0) * s), (double)(((float)y + h) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUX, (double)maxVY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)(((float)y + h) * s), (double)((float)(z + 0) * s)).func_187315_a((double)maxUX, (double)maxVY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)((float)(y + 0) * s), (double)((float)(z + 0) * s)).func_187315_a((double)maxUX, (double)minVY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)((float)(y + 0) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUX, (double)minVY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)(((float)y + h) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUX, (double)maxVY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)(((float)y + h) * s), (double)(((float)z + d) * s)).func_187315_a((double)minUX, (double)maxVY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)((float)(y + 0) * s), (double)(((float)z + d) * s)).func_187315_a((double)minUX, (double)minVY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)((float)(y + 0) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUX, (double)minVY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)((float)(y + 0) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUZ, (double)minVY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)(((float)y + h) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUZ, (double)maxVY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)(((float)y + h) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUZ, (double)maxVY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)((float)(y + 0) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUZ, (double)minVY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)((float)(y + 0) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUZ, (double)minVY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)(((float)y + h) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUZ, (double)maxVY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)(((float)y + h) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUZ, (double)maxVY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)((float)(y + 0) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUZ, (double)minVY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        }
        if (renderBottom) {
            vb.func_181662_b((double)((float)(x + 0) * s), (double)((float)(y + 0) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUZ, (double)minVX).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)((float)(y + 0) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUZ, (double)maxVX).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)((float)(y + 0) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUZ, (double)maxVX).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)((float)(y + 0) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUZ, (double)minVX).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        if (renderTop) {
            vb.func_181662_b((double)((float)(x + 0) * s), (double)(((float)y + h) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUZ, (double)minVX).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)((float)(x + 0) * s), (double)(((float)y + h) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUZ, (double)minVX).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)(((float)y + h) * s), (double)(((float)z + d) * s)).func_187315_a((double)maxUZ, (double)maxVX).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            vb.func_181662_b((double)(((float)x + w) * s), (double)(((float)y + h) * s), (double)((float)(z + 0) * s)).func_187315_a((double)minUZ, (double)maxVX).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        }
        tess.func_78381_a();
    }
}

