/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.client.guiparticle;

import java.util.Random;
import net.minecraft.client.gui.Gui;

public class GuiParticle {
    public double prevPosX;
    public double prevPosY;
    public double posX;
    public double posY;
    public double motionX;
    public double motionY;
    public boolean expired;
    public int age;
    public int maxAge;
    public float gravity;
    public Random rand = new Random();
    public float red = 1.0f;
    public float green = 1.0f;
    public float blue = 1.0f;

    public GuiParticle(double x, double y) {
        this.posX = x;
        this.posY = y;
        this.prevPosX = x;
        this.prevPosY = y;
        this.maxAge = (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f));
        this.age = 0;
        this.motionX = this.rand.nextFloat() - 0.5f;
        this.motionY = this.rand.nextFloat() - 0.5f;
        this.gravity = 12.0f;
    }

    public void setExpired() {
        this.expired = true;
    }

    public void update() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        if (this.age++ >= this.maxAge) {
            this.setExpired();
        }
        this.motionY += 0.04 * (double)this.gravity;
        this.motionX *= 0.98;
        this.motionY *= 0.98;
        this.posX += this.motionX;
        this.posY += this.motionY;
    }

    public void render(float partialTicks) {
        double interpPosX = this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks;
        double interpPosY = this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks;
        Gui.func_73734_a((int)((int)interpPosX - 2), (int)((int)interpPosY - 2), (int)((int)interpPosX + 2), (int)((int)interpPosY + 2), (int)-1);
    }
}

