/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.logic;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.logic.HeartContainer;
import com.elytradev.glasshearts.logic.HeartContainerOwner;
import com.elytradev.glasshearts.logic.IGlassHeart;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart;
import com.elytradev.glasshearts.world.GlassHeartWorldData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class BlockHeartContainerOwner
extends HeartContainerOwner {
    private World world;
    private BlockPos pos;

    public BlockHeartContainerOwner() {
    }

    public BlockHeartContainerOwner(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public IGlassHeart getGlassHeart() {
        if (this.pos == null) {
            return null;
        }
        if (this.world == null) {
            return null;
        }
        if (this.world.func_175667_e(this.pos)) {
            TileEntity te = this.world.func_175625_s(this.pos);
            if (te instanceof TileEntityGlassHeart) {
                return (TileEntityGlassHeart)te;
            }
            return null;
        }
        GlassHeartWorldData ghwd = GlassHeartWorldData.getDataFor(this.world);
        return ghwd.get(this.pos);
    }

    @Override
    public void modify(float change) {
        IGlassHeart igh = this.getGlassHeart();
        if (igh != null) {
            int mb = MathHelper.func_76123_f((float)((float)igh.getLifeforceCapacity() * change));
            igh.setLifeforce(igh.getLifeforce() + mb);
            for (EntityPlayer ep : GlassHearts.getAllOnlineAttunedPlayers(igh)) {
                ep.func_71064_a(GlassHearts.inst.LIFEFORCE_CONSUMED, mb);
            }
        }
    }

    @Override
    public void set(float amount) {
        IGlassHeart igh = this.getGlassHeart();
        if (igh != null) {
            igh.setLifeforce(MathHelper.func_76123_f((float)((float)igh.getLifeforceCapacity() * amount)));
        }
    }

    @Override
    public HeartContainer sync(HeartContainer hc) {
        IGlassHeart igh = this.getGlassHeart();
        float fill = (float)igh.getLifeforce() / (float)igh.getLifeforceCapacity();
        int amt = (int)(fill * 255.0f);
        if (hc.getFillAmountInt() != amt || hc.getGem() != igh.getGem()) {
            hc = hc.copy();
            hc.setFillAmountInt(amt);
            hc.setGem(igh.getGem());
        }
        return hc;
    }

    @Override
    public boolean isValid() {
        return this.getGlassHeart() != null;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public World getWorld() {
        return this.world;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("Pos", this.pos.func_177986_g());
        tag.func_74768_a("Dim", this.world.field_73011_w.getDimension());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.pos = BlockPos.func_177969_a((long)nbt.func_74763_f("Pos"));
        this.world = DimensionManager.getWorld((int)nbt.func_74762_e("Dim"));
    }

    @Override
    public HeartContainerOwner copy() {
        return new BlockHeartContainerOwner(this.world, this.pos);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
        result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        BlockHeartContainerOwner other = (BlockHeartContainerOwner)that;
        if (this.pos == null ? other.pos != null : !this.pos.equals((Object)other.pos)) {
            return false;
        }
        return !(this.world == null ? other.world != null : !this.world.equals(other.world));
    }
}

