/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.logic;

import com.elytradev.glasshearts.capability.CapabilityHeartHandler;
import com.elytradev.glasshearts.capability.IHeartHandler;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.logic.HeartContainer;
import com.elytradev.glasshearts.logic.HeartContainerOwner;
import com.elytradev.glasshearts.network.PlayHeartEffectMessage;
import com.elytradev.glasshearts.network.UpdateHeartsMessage;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.reflect.accessor.Accessor;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.reflect.accessor.Accessors;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.FoodStats;

public class PlayerHandler {
    private static final Accessor<Integer> foodTimer = Accessors.findField(FoodStats.class, "field_75123_d", "foodTimer", "d");
    private final WeakReference<EntityPlayer> player;
    private final List<HeartContainer> lastContainers = Lists.newArrayList();

    public PlayerHandler(EntityPlayer player) {
        this.player = new WeakReference<EntityPlayer>(player);
    }

    protected EntityPlayer getPlayer() {
        EntityPlayer ep = (EntityPlayer)this.player.get();
        return ep == null || ep.field_70128_L ? null : ep;
    }

    protected IHeartHandler getHeartHandler(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity.hasCapability(CapabilityHeartHandler.CAPABILITY, null)) {
            return (IHeartHandler)entity.getCapability(CapabilityHeartHandler.CAPABILITY, null);
        }
        return null;
    }

    public void preTick() {
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        IHeartHandler ihh = this.getHeartHandler((Entity)player);
        if (ihh == null) {
            return;
        }
        float hp = 0.0f;
        int destroyed = 0;
        for (int i = 0; i < ihh.getContainers(); ++i) {
            Object hc = ihh.getContainer(i);
            HeartContainerOwner owner = ((HeartContainer)hc).getOwner();
            if (owner == null) continue;
            if (owner.isValid()) {
                Object original = hc;
                if (original == (hc = owner.sync((HeartContainer)hc))) continue;
                ihh.setContainer(i, (HeartContainer)hc);
                continue;
            }
            ihh.removeContainer(i);
            new PlayHeartEffectMessage(0, ((HeartContainer)hc).getGlassColor().ordinal(), i + destroyed).sendTo(player);
            if (((HeartContainer)hc).getGem() != Gems.NONE) {
                new PlayHeartEffectMessage(1, Gem.getIdForGem(((HeartContainer)hc).getGem()), i + destroyed).sendTo(player);
            }
            ++destroyed;
            --i;
        }
        boolean anyHealableEmpty = false;
        for (HeartContainer hc : ihh) {
            hp += hc.getFillAmount();
            if (!hc.canHeal() || !(hc.getFillAmount() < 1.0f)) continue;
            anyHealableEmpty = true;
        }
        boolean naturalRegeneration = player.field_70170_p.func_82736_K().func_82766_b("naturalRegeneration");
        FoodStats food = player.func_71024_bL();
        if (naturalRegeneration && !anyHealableEmpty && player.func_70996_bM() && food.func_75116_a() >= 18) {
            foodTimer.set(food, 0);
        }
        player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(ihh.getContainers() * 2));
        if (player.func_70089_S()) {
            player.func_70606_j((float)((int)(hp * 2.0f)));
        } else {
            player.func_70606_j(0.0f);
        }
    }

    public void postTick() {
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.resync();
    }

    public void resync() {
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        IHeartHandler ihh = this.getHeartHandler((Entity)player);
        if (ihh == null) {
            return;
        }
        if (this.lastContainers.isEmpty()) {
            for (HeartContainer hc : ihh) {
                this.lastContainers.add(hc);
            }
            new UpdateHeartsMessage(0, true, Lists.newArrayList((Iterable)ihh)).sendTo(player);
        } else {
            int start = -1;
            ArrayList sync = Collections.emptyList();
            int lastChanged = -1;
            for (int i = 0; i < Math.max(this.lastContainers.size(), ihh.getContainers()); ++i) {
                HeartContainer cur;
                HeartContainer last = i >= this.lastContainers.size() ? null : this.lastContainers.get(i);
                HeartContainer heartContainer = cur = i >= ihh.getContainers() ? null : ihh.getContainer(i);
                if (start == -1) {
                    if (Objects.equal((Object)last, (Object)cur)) continue;
                    start = i;
                    sync = Lists.newArrayList((Object[])new HeartContainer[]{cur});
                    lastChanged = i;
                    continue;
                }
                sync.add(cur);
                if (Objects.equal((Object)last, (Object)cur)) continue;
                lastChanged = i;
            }
            if (start != -1) {
                this.lastContainers.clear();
                for (HeartContainer hc : ihh) {
                    this.lastContainers.add(hc);
                }
                List<HeartContainer> sub = sync.subList(0, lastChanged - start + 1);
                new UpdateHeartsMessage(start, false, sub).sendTo(player);
            }
        }
    }
}

