/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.network;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.client.particle.ParticleAttune;
import com.elytradev.glasshearts.client.particle.ParticleRedstoneSeekEntity;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.annotation.field.MarshalledAs;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.annotation.type.ReceivedOn;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.client.particle.ParticleSpell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ReceivedOn(value=Side.CLIENT)
public class ParticleEffectMessage
extends Message {
    public static final int EFFECT_SAP = 0;
    public static final int EFFECT_ATTUNE = 1;
    public static final int EFFECT_AMETHYST = 2;
    public static final int EFFECT_TOPAZ = 3;
    public static final int EFFECT_AGATE = 4;
    @MarshalledAs(value="i32")
    public int posXFixed;
    @MarshalledAs(value="i32")
    public int posYFixed;
    @MarshalledAs(value="i32")
    public int posZFixed;
    @MarshalledAs(value="i32")
    public int targetid;
    @MarshalledAs(value="u8")
    public int effect;

    public ParticleEffectMessage(NetworkContext ctx) {
        super(ctx);
    }

    public ParticleEffectMessage(double x, double y, double z, Entity target, int effect) {
        super(GlassHearts.inst.NETWORK);
        this.posXFixed = (int)(x * 32.0);
        this.posYFixed = (int)(y * 32.0);
        this.posZFixed = (int)(z * 32.0);
        this.targetid = target.func_145782_y();
        this.effect = effect;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityPlayer sender) {
        Entity target = sender.field_70170_p.func_73045_a(this.targetid);
        if (target == null) {
            return;
        }
        double posX = (double)this.posXFixed / 32.0;
        double posY = (double)this.posYFixed / 32.0;
        double posZ = (double)this.posZFixed / 32.0;
        if (this.effect == 0 || this.effect == 1) {
            float r = 0.1f;
            for (int i = 0; i < (this.effect == 0 ? 128 : 256); ++i) {
                ParticleRedstone p;
                float x = (float)target.field_70170_p.field_73012_v.nextGaussian();
                float y = (float)target.field_70170_p.field_73012_v.nextGaussian();
                float z = (float)target.field_70170_p.field_73012_v.nextGaussian();
                if (this.effect == 0) {
                    p = new ParticleRedstoneSeekEntity(target, target.field_70170_p, posX + (double)(r * x), posY + (double)(r * y), posZ + (double)(r * z), 1.0f, 0.8f, 0.0f, 0.0f);
                    p.setVelocity(x / 4.0f, y / 4.0f, z / 4.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
                    continue;
                }
                if (this.effect != 1) continue;
                p = new ParticleAttune(target, target.field_70170_p, posX + (double)(r * x), posY + (double)(r * y), posZ + (double)(r * z), 1.0f, 0.8f, 0.0f, 0.0f);
                p.setVelocity(x / 4.0f, y / 4.0f, z / 4.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
            }
        } else {
            for (int i = 0; i < 64; ++i) {
                double r = 0.0;
                double g = 0.0;
                double b = 0.0;
                if (this.effect == 2) {
                    r = 0.8;
                    g = 0.36;
                    b = 0.67;
                } else if (this.effect == 3) {
                    r = 0.15;
                    g = 0.32;
                    b = 0.65;
                } else if (this.effect == 4) {
                    r = 0.58;
                    g = 0.14;
                    b = 0.14;
                }
                Particle p = new ParticleSpell.MobFactory().func_178902_a(0, target.field_70170_p, posX, posY + target.field_70170_p.field_73012_v.nextGaussian() / 2.0, posZ, r, g, b, new int[0]);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(p);
            }
        }
    }
}

