/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.repackage.com.elytradev.concrete.network;

import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.NetworkContext$$Lambda$1;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.NetworkContext$$Lambda$2;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.NetworkContext$$Lambda$3;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.NetworkContext$$Lambda$4;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.WireField;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.annotation.field.Optional;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.exception.BadMessageException;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.exception.WrongSideException;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.reflect.instanciator.Instanciator;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.reflect.instanciator.Instanciators;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkContext {
    static final Logger log = LogManager.getLogger((String)"Concrete");
    private static final String DEFAULT_PACKAGE;
    protected static final Map<Class<? extends Message>, Instanciator<? extends Message>> instanciators;
    protected final BiMap<Class<? extends Message>, Integer> packetIds = HashBiMap.create();
    protected final Map<Class<? extends Message>, List<WireField<?>>> marshallers = Maps.newHashMap();
    protected final Multiset<Class<? extends Message>> booleanCount = HashMultiset.create();
    protected final Multiset<Class<? extends Message>> optionalCount = HashMultiset.create();
    protected final String channel;
    private int nextPacketId = 0;

    private NetworkContext(String channel) {
        if (NetworkContext.class.getName().startsWith(DEFAULT_PACKAGE)) {
            if (!((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                throw new RuntimeException("Concrete is designed to be shaded and must not be left in the default package! (Offending mod: " + Loader.instance().activeModContainer().getName() + ")");
            }
            log.warn("Concrete is in the default package. This is not a fatal error, as you are in a development environment, but remember to repackage it!");
        }
        this.channel = channel;
        NetworkRegistry.INSTANCE.newEventDrivenChannel(channel).register((Object)this);
    }

    public NetworkContext register(Class<? extends Message> clazz) {
        if (this.packetIds.containsKey(clazz)) {
            log.warn("{} was registered twice", new Object[]{clazz});
            return this;
        }
        this.packetIds.put(clazz, (Object)this.nextPacketId++);
        ArrayList fields = Lists.newArrayList();
        for (Class<? extends Message> cursor = clazz; cursor != null && cursor != Object.class; cursor = cursor.getSuperclass()) {
            for (Field f : cursor.getDeclaredFields()) {
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                if (f.getType() == Boolean.TYPE) {
                    this.booleanCount.add(clazz);
                }
                if (f.getAnnotation(Optional.class) != null) {
                    this.optionalCount.add(clazz);
                }
                WireField wf = new WireField(f);
                fields.add(wf);
            }
        }
        this.marshallers.put(clazz, fields);
        return this;
    }

    public String getChannel() {
        return this.channel;
    }

    protected FMLProxyPacket getPacketFrom(Message m) {
        if (!this.packetIds.containsKey(m.getClass())) {
            throw new BadMessageException(m.getClass() + " is not registered");
        }
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer());
        payload.writeByte(((Integer)this.packetIds.get(m.getClass())).intValue());
        int bools = this.booleanCount.count(m.getClass()) + this.optionalCount.count(m.getClass());
        if (bools > 0) {
            ArrayList li = Lists.newArrayListWithCapacity((int)bools);
            for (WireField<?> wf : this.marshallers.get(m.getClass())) {
                if (wf.getType() == Boolean.TYPE) {
                    li.add((Boolean)wf.get(m));
                    continue;
                }
                if (!wf.isOptional()) continue;
                li.add(wf.get(m) != null);
            }
            for (int i = 0; i < (bools + 7) / 8; ++i) {
                int by = 0;
                for (int j = i * 8; j < Math.min(li.size(), i + 8); ++j) {
                    if (!((Boolean)li.get(j)).booleanValue()) continue;
                    by |= 1 << j;
                }
                payload.writeByte(by);
            }
        }
        UnmodifiableIterator iter = Iterators.filter(this.marshallers.get(m.getClass()).iterator(), (Predicate)NetworkContext$$Lambda$1.lambdaFactory$());
        while (iter.hasNext()) {
            WireField wf = (WireField)iter.next();
            wf.marshal(m, (ByteBuf)payload);
        }
        return new FMLProxyPacket(payload, this.channel);
    }

    @SubscribeEvent
    public void onServerCustomPacket(FMLNetworkEvent.ServerCustomPacketEvent e) {
        ByteBuf payload = e.getPacket().payload();
        Message m = this.readPacket(e.side(), payload);
        m.doHandleServer((EntityPlayer)((NetHandlerPlayServer)e.getHandler()).field_147369_b);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientCustomPacket(FMLNetworkEvent.ClientCustomPacketEvent e) {
        ByteBuf payload = e.getPacket().payload();
        Message m = this.readPacket(e.side(), payload);
        m.doHandleClient();
    }

    /*
     * WARNING - void declaration
     */
    private Message readPacket(Side side, ByteBuf payload) {
        Message m;
        short id = payload.readUnsignedByte();
        if (!this.packetIds.containsValue((Object)id)) {
            throw new IllegalArgumentException("Unknown packet id " + id);
        }
        Class clazz = (Class)this.packetIds.inverse().get((Object)id);
        try {
            if (!instanciators.containsKey(clazz)) {
                Constructor cons = clazz.getConstructor(NetworkContext.class);
                instanciators.put(clazz, Instanciators.from(cons));
            }
            m = instanciators.get(clazz).newInstance(this);
        }
        catch (Throwable t) {
            throw new BadMessageException("Cannot instanciate message class " + clazz, t);
        }
        if (m.getSide() != side) {
            throw new WrongSideException("Cannot receive packet of type " + clazz + " on side " + side);
        }
        HashSet present = Sets.newHashSetWithExpectedSize((int)this.marshallers.get(m.getClass()).size());
        int bools = this.booleanCount.count(m.getClass()) + this.optionalCount.count(m.getClass());
        if (bools > 0) {
            void var9_12;
            ArrayList li = Lists.newArrayListWithCapacity((int)bools);
            for (WireField<?> wf : this.marshallers.get(m.getClass())) {
                if (wf.getType() == Boolean.TYPE) {
                    li.add(NetworkContext$$Lambda$2.lambdaFactory$(wf, m));
                    present.add(wf);
                    continue;
                }
                if (wf.isOptional()) {
                    li.add(NetworkContext$$Lambda$3.lambdaFactory$(present, wf));
                    continue;
                }
                present.add(wf);
            }
            boolean bl = false;
            while (var9_12 < (bools + 7) / 8) {
                short by = payload.readUnsignedByte();
                for (void j = var9_12 * 8; j < Math.min(li.size(), (int)(var9_12 + 8)); ++j) {
                    boolean val = (by & 1 << j - var9_12) != 0;
                    ((Consumer)li.get((int)j)).accept(val);
                }
                ++var9_12;
            }
        } else {
            for (WireField wireField : this.marshallers.get(m.getClass())) {
                present.add(wireField);
            }
        }
        UnmodifiableIterator iter = Iterators.filter(this.marshallers.get(m.getClass()).iterator(), (Predicate)NetworkContext$$Lambda$4.lambdaFactory$());
        while (iter.hasNext()) {
            WireField wireField = (WireField)iter.next();
            if (!present.contains(wireField)) continue;
            wireField.unmarshal(m, payload);
        }
        return m;
    }

    public static NetworkContext forChannel(String channel) {
        if (channel.length() > 20) {
            throw new IllegalArgumentException("Channel name too long, must be at most 20 characters");
        }
        return new NetworkContext(channel);
    }

    private static /* synthetic */ boolean lambda$readPacket$3(WireField it) {
        return it.getType() != Boolean.TYPE;
    }

    private static /* synthetic */ void lambda$readPacket$2(Set present, WireField wf, Boolean b) {
        if (b.booleanValue()) {
            present.add(wf);
        }
    }

    private static /* synthetic */ boolean lambda$getPacketFrom$0(WireField it) {
        return it.getType() != Boolean.TYPE;
    }

    static {
        char[] c = new char[]{'c', 'o', 'm', '.', 'e', 'l', 'y', 't', 'r', 'a', 'd', 'e', 'v', '.', 'c', 'o', 'n', 'c', 'r', 'e', 't', 'e'};
        DEFAULT_PACKAGE = new String(c);
        instanciators = Maps.newHashMap();
    }

    static /* synthetic */ boolean access$lambda$0(WireField wireField) {
        return NetworkContext.lambda$getPacketFrom$0(wireField);
    }

    static /* synthetic */ void access$lambda$1(WireField wireField, Message message, Boolean bl) {
        wireField.set(message, bl);
    }

    static /* synthetic */ void access$lambda$2(Set set, WireField wireField, Boolean bl) {
        NetworkContext.lambda$readPacket$2(set, wireField, bl);
    }

    static /* synthetic */ boolean access$lambda$3(WireField wireField) {
        return NetworkContext.lambda$readPacket$3(wireField);
    }
}

