/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.repackage.com.elytradev.concrete.reflect.accessor;

import com.elytradev.glasshearts.repackage.com.elytradev.concrete.reflect.accessor.Accessor;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class MethodHandlesAccessor<T>
implements Accessor<T> {
    private MethodHandle getter;
    private MethodHandle setter;

    public MethodHandlesAccessor(Field f) {
        try {
            f.setAccessible(true);
            this.getter = MethodHandles.lookup().unreflectGetter(f);
            this.setter = MethodHandles.lookup().unreflectSetter(f);
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public MethodHandlesAccessor(Method get, Method set) {
        try {
            get.setAccessible(true);
            set.setAccessible(true);
            this.getter = MethodHandles.lookup().unreflect(get);
            this.setter = MethodHandles.lookup().unreflect(set);
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public T get(Object owner) {
        try {
            return (T)this.getter.invoke(owner);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void set(Object owner, T value) {
        try {
            this.setter.invoke(owner, value);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

