/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.tile;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.logic.IGlassHeart;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart$$Lambda$1;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart$$Lambda$3;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart$$Lambda$4;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart$$Lambda$5;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart$$Lambda$6;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart$$Lambda$7;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart$$Lambda$8;
import com.elytradev.glasshearts.world.GlassHeartData;
import com.elytradev.glasshearts.world.GlassHeartWorldData;
import com.google.common.base.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityGlassHeart
extends TileEntity
implements IFluidHandler,
IGlassHeart,
IItemHandler {
    private boolean client = false;
    private int clientLifeforce = 0;
    private int clientLifeforceCapacity = 0;
    private int clientLifeforceBuffer = 0;
    private EnumGlassColor clientColor = EnumGlassColor.NONE;
    private Gem clientGem = Gems.NONE;
    private ItemStack clientGemStack = ItemStack.field_190927_a;
    private boolean clientHasBeenFull = false;
    private String name;

    public void onLoad() {
        super.onLoad();
        GlassHearts.proxy.onLoad(this);
    }

    public ITextComponent func_145748_c_() {
        return this.name == null ? null : new TextComponentString(this.name);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74777_a("Lifeforce", (short)this.getLifeforce());
        tag.func_74777_a("LifeforceCapacity", (short)this.getLifeforceCapacity());
        tag.func_74777_a("LifeforceBuffer", (short)this.getLifeforceBuffer());
        tag.func_74774_a("Color", (byte)this.getColor().ordinal());
        tag.func_74782_a("GemStack", (NBTBase)this.getGemStack().serializeNBT());
        tag.func_74774_a("Gem", (byte)Gem.getIdForGem(this.getGem()));
        tag.func_74757_a("HasBeenFull", this.hasBeenFull());
        if (this.name != null) {
            tag.func_74778_a("Name", this.name);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.name = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.name != null) {
            compound.func_74778_a("CustomName", this.name);
        }
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.getHeartPos(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.client = true;
        this.clientLifeforce = tag.func_74762_e("Lifeforce");
        this.clientLifeforceBuffer = tag.func_74762_e("LifeforceBuffer");
        this.clientLifeforceCapacity = tag.func_74762_e("LifeforceCapacity");
        this.clientColor = EnumGlassColor.values()[tag.func_74771_c("Color")];
        this.clientGem = Gem.getGemById(tag.func_74771_c("Gem") & 0xFF);
        this.clientGemStack = new ItemStack(tag.func_74775_l("GemStack"));
        this.clientHasBeenFull = tag.func_74767_n("HasBeenFull");
        this.name = tag.func_150297_b("Name", 8) ? tag.func_74779_i("Name") : null;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 || pass == 0;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public Optional<GlassHeartData> getData() {
        return this.func_145830_o() && !this.field_145850_b.field_72995_K ? Optional.fromNullable((Object)GlassHeartWorldData.getDataFor(this.field_145850_b).get(this.getHeartPos())) : Optional.absent();
    }

    public GlassHeartData getOrCreateData() {
        Optional<GlassHeartData> cur = this.getData();
        if (cur.isPresent()) {
            return (GlassHeartData)cur.get();
        }
        GlassHeartWorldData ghwd = GlassHeartWorldData.getDataFor(this.field_145850_b);
        return ghwd.create(this.getHeartPos(), EnumGlassColor.NONE, ItemStack.field_190927_a, 0, 0);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getLifeforce() {
        if (this.client) {
            return this.clientLifeforce;
        }
        return (Integer)this.getData().transform(TileEntityGlassHeart$$Lambda$1.lambdaFactory$()).or((Object)0);
    }

    @Override
    public int getLifeforceCapacity() {
        if (this.client) {
            return this.clientLifeforceCapacity;
        }
        return (Integer)this.getData().transform(TileEntityGlassHeart$$Lambda$3.lambdaFactory$()).or((Object)0);
    }

    @Override
    public EnumGlassColor getColor() {
        if (this.client) {
            return this.clientColor;
        }
        return (EnumGlassColor)((Object)this.getData().transform(TileEntityGlassHeart$$Lambda$4.lambdaFactory$()).or((Object)EnumGlassColor.NONE));
    }

    @Override
    public Gem getGem() {
        if (this.client) {
            return this.clientGem;
        }
        return (Gem)((Object)this.getData().transform(TileEntityGlassHeart$$Lambda$5.lambdaFactory$()).or((Object)Gems.NONE));
    }

    @Override
    public ItemStack getGemStack() {
        if (this.client) {
            return this.clientGemStack;
        }
        return (ItemStack)this.getData().transform(TileEntityGlassHeart$$Lambda$6.lambdaFactory$()).or((Object)ItemStack.field_190927_a);
    }

    @Override
    public int getLifeforceBuffer() {
        if (this.client) {
            return this.clientLifeforceBuffer;
        }
        return (Integer)this.getData().transform(TileEntityGlassHeart$$Lambda$7.lambdaFactory$()).or((Object)0);
    }

    @Override
    public boolean hasBeenFull() {
        if (this.client) {
            return this.clientHasBeenFull;
        }
        return (Boolean)this.getData().transform(TileEntityGlassHeart$$Lambda$8.lambdaFactory$()).or((Object)false);
    }

    public void setName(String name) {
        this.name = name;
        GlassHearts.sendUpdatePacket(this);
        this.func_70296_d();
    }

    @Override
    public void setLifeforce(int lifeforce) {
        if (this.client) {
            this.clientLifeforce = lifeforce;
            return;
        }
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        int oldLifeforce = this.getLifeforce();
        this.getOrCreateData().setLifeforce(lifeforce);
        if (oldLifeforce != lifeforce) {
            GlassHearts.sendUpdatePacket(this);
            this.func_145831_w().func_175666_e(this.func_174877_v(), this.func_145838_q());
        }
    }

    @Override
    public void setColor(EnumGlassColor color) {
        if (this.client) {
            this.clientColor = color;
            return;
        }
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        EnumGlassColor oldColor = this.getColor();
        this.getOrCreateData().setColor(color);
        if (oldColor != color) {
            GlassHearts.sendUpdatePacket(this);
        }
    }

    @Override
    public void setGemStack(ItemStack gemStack) {
        if (this.client) {
            this.clientGem = Gem.fromItemStack(gemStack);
            this.clientGemStack = gemStack;
            return;
        }
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        Gem oldGem = this.getGem();
        ItemStack oldGemStack = this.getGemStack();
        this.getOrCreateData().setGemStack(gemStack);
        Gem newGem = this.getGem();
        if (oldGem != newGem || !ItemStack.func_77989_b((ItemStack)oldGemStack, (ItemStack)gemStack)) {
            GlassHearts.sendUpdatePacket(this);
        }
    }

    @Override
    public void setLifeforceBuffer(int lifeforceBuffer) {
        if (this.client) {
            this.clientLifeforceBuffer = lifeforceBuffer;
        }
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        int oldLifeforceBuffer = this.getLifeforceBuffer();
        this.getOrCreateData().setLifeforceBuffer(lifeforceBuffer);
        if (oldLifeforceBuffer != lifeforceBuffer) {
            GlassHearts.sendUpdatePacket(this);
            this.func_145831_w().func_175666_e(this.func_174877_v(), this.func_145838_q());
        }
    }

    @Override
    public void setHasBeenFull(boolean hasBeenFull) {
        if (this.client) {
            this.clientHasBeenFull = hasBeenFull;
        }
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        boolean oldHasBeenFull = this.hasBeenFull();
        this.getOrCreateData().setHasBeenFull(hasBeenFull);
        if (oldHasBeenFull != hasBeenFull) {
            GlassHearts.sendUpdatePacket(this);
        }
    }

    @Override
    public BlockPos getHeartPos() {
        return this.func_174877_v();
    }

    @Override
    public World getHeartWorld() {
        return this.func_145831_w();
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(GlassHearts.inst.LIFEFORCE, this.getLifeforceBuffer()), this.getLifeforceCapacity() - this.getLifeforce(), true, false), new FluidTankProperties(new FluidStack(GlassHearts.inst.LIFEFORCE, this.getLifeforce()), this.getLifeforceCapacity(), false, false)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == GlassHearts.inst.LIFEFORCE) {
            int max = this.getLifeforceCapacity() - this.getLifeforce() - this.getLifeforceBuffer();
            int amt = Math.min(resource.amount, max);
            if (doFill) {
                this.setLifeforceBuffer(this.getLifeforceBuffer() + amt);
            }
            return amt;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == GlassHearts.inst.LIFEFORCE) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int amt = Math.min(this.getLifeforceBuffer(), maxDrain);
        if (doDrain) {
            this.setLifeforceBuffer(this.getLifeforceBuffer() - amt);
        }
        return amt < 0 ? null : new FluidStack(GlassHearts.inst.LIFEFORCE, amt);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        return this.getGemStack();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        Gem eg;
        if (slot != 0) {
            return stack;
        }
        if (this.getGemStack().func_190926_b() && (eg = Gem.fromItemStack(stack)) != Gems.NONE) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190918_g(1);
            if (!simulate) {
                ItemStack gemStack = stack.func_77946_l();
                gemStack.func_190920_e(1);
                this.setGemStack(gemStack);
            }
            return copy;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.getGemStack();
        if (!simulate) {
            this.setGemStack(ItemStack.field_190927_a);
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }
}

