/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.capability;

import com.elytradev.glasshearts.capability.IHeartHandler;
import com.elytradev.glasshearts.logic.HeartContainer;
import java.util.Iterator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;

public class BasicHeartHandler
implements IHeartHandler {
    protected final NonNullList<HeartContainer> list = NonNullList.func_191196_a();

    @Override
    public float damage(float amount, DamageSource src) {
        float origAmount = amount;
        for (int i = this.getContainers() - 1; i >= 0 && !(amount <= 0.0f); --i) {
            HeartContainer hc = this.getContainer(i).copy();
            float consumed = hc.damage(amount, src);
            if (!(consumed > 0.0f)) continue;
            amount -= consumed;
            this.setContainer(i, hc);
        }
        return origAmount - amount;
    }

    @Override
    public float heal(float amount) {
        float origAmount = amount;
        for (int i = 0; i < this.getContainers() && !(amount <= 0.0f); ++i) {
            HeartContainer hc = this.getContainer(i).copy();
            float consumed = hc.heal(amount);
            if (!(consumed > 0.0f)) continue;
            this.setContainer(i, hc);
            amount -= consumed;
        }
        return origAmount - amount;
    }

    protected NonNullList<HeartContainer> getList() {
        return this.list;
    }

    @Override
    public int getContainers() {
        return this.getList().size();
    }

    @Override
    public HeartContainer getContainer(int index) {
        return (HeartContainer)this.getList().get(index);
    }

    @Override
    public HeartContainer copyContainer(int index) {
        return this.getContainer(index).copy();
    }

    @Override
    public HeartContainer popContainer(int index) {
        return (HeartContainer)this.getList().remove(index);
    }

    @Override
    public void setContainer(int index, HeartContainer container) {
        this.getList().set(index, (Object)container);
    }

    @Override
    public void removeContainer(int index) {
        this.getList().remove(index);
    }

    @Override
    public void addContainer(HeartContainer container) {
        this.getList().add((Object)container);
    }

    @Override
    public void addContainer(int index, HeartContainer container) {
        this.getList().add(index, (Object)container);
    }

    @Override
    public void clear() {
        this.getList().clear();
    }

    @Override
    public Iterator<HeartContainer> iterator() {
        return this.getList().iterator();
    }

    @Override
    public float totalHealth() {
        float total = 0.0f;
        for (HeartContainer hc : this) {
            total += hc.getFillAmount();
        }
        return total;
    }
}

