/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.capability;

import com.elytradev.glasshearts.capability.BasicHeartHandler;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.logic.HeartContainer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;

public class EntityHeartHandler
extends BasicHeartHandler {
    protected EntityLivingBase elb;
    protected boolean initialized = false;

    public EntityHeartHandler(EntityLivingBase elb) {
        this.elb = elb;
    }

    @Override
    public float damage(float amount, DamageSource src) {
        float origAmount = amount;
        for (int i = this.getContainers() - 1; i >= 0 && !(amount <= 0.0f); --i) {
            HeartContainer orig = this.getContainer(i);
            HeartContainer hc = orig.copy();
            float consumed = hc.damage(amount, src);
            if (!(consumed > 0.0f)) continue;
            amount -= consumed;
            this.setContainer(i, hc);
        }
        return origAmount - amount;
    }

    @Override
    protected NonNullList<HeartContainer> getList() {
        if (!this.initialized) {
            int max = MathHelper.func_76123_f((float)(this.elb.func_110138_aP() / 2.0f));
            float hp = this.elb.func_110143_aJ() / 2.0f;
            for (int i = 0; i < max; ++i) {
                super.getList().add((Object)HeartContainer.createNatural(Gems.NONE, Math.min(Math.max(hp, 0.0f), 1.0f)));
                hp -= 1.0f;
            }
            this.initialized = true;
        }
        return super.getList();
    }
}

