/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.gem;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.enums.EnumGemState;
import com.elytradev.glasshearts.gem.GemAgate;
import com.elytradev.glasshearts.gem.GemAmber;
import com.elytradev.glasshearts.gem.GemAmethyst;
import com.elytradev.glasshearts.gem.GemDiamond;
import com.elytradev.glasshearts.gem.GemEmerald;
import com.elytradev.glasshearts.gem.GemNone;
import com.elytradev.glasshearts.gem.GemOnyx;
import com.elytradev.glasshearts.gem.GemOpal;
import com.elytradev.glasshearts.gem.GemRuby;
import com.elytradev.glasshearts.gem.GemSapphire;
import com.elytradev.glasshearts.gem.GemTopaz;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.logic.HeartContainer;
import com.elytradev.glasshearts.logic.IGlassHeart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.ArrayUtils;

public abstract class Gem
extends IForgeRegistryEntry.Impl<Gem> {
    public static ForgeRegistry<Gem> REGISTRY;
    private static final ResourceLocation MISSING;
    private final String oreName;
    private final int color;
    private ResourceLocation tex = MISSING;
    private int texWidth = 256;
    private int texHeight = 256;
    private int u = 0;
    private int v = 0;
    private int width = 256;
    private int height = 256;

    public static Gem getGemById(int id) {
        return (Gem)REGISTRY.getValue(id);
    }

    public static int getIdForGem(Gem gem) {
        return REGISTRY.getID((IForgeRegistryEntry)gem);
    }

    public Gem(int color, String oreName) {
        this.color = color;
        this.oreName = oreName;
    }

    protected Gem setDefaultTexture(int u) {
        return this.setTexture(GlassHearts.TEX, 256, 256, 9 + u * 9, 54, 9, 9);
    }

    protected Gem setTexture(ResourceLocation tex) {
        return this.setTexture(tex, 9, 9, 0, 0, 9, 9);
    }

    protected Gem setTexture(ResourceLocation tex, int u, int v, int width, int height) {
        return this.setTexture(tex, 256, 256, u, v, width, height);
    }

    protected Gem setTexture(ResourceLocation tex, int texWidth, int texHeight, int u, int v, int width, int height) {
        this.tex = tex;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public EnumGemState getState(IGlassHeart igh) {
        return igh.getLifeforce() > 0 ? EnumGemState.ACTIVE_BENEFICIAL : EnumGemState.INACTIVE;
    }

    public static Gem fromItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Gems.NONE;
        }
        for (Gem gem : REGISTRY.getValues()) {
            if (!gem.itemStackMatches(stack)) continue;
            return gem;
        }
        return Gems.NONE;
    }

    public boolean itemStackMatches(ItemStack stack) {
        if (this.oreName == null) {
            return false;
        }
        int oreId = OreDictionary.getOreID((String)this.oreName);
        return ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)oreId);
    }

    public float getMultiplier(DamageSource src) {
        return 1.0f;
    }

    public void onEmpty(IGlassHeart igh) {
    }

    public void update(IGlassHeart igh, long ticks) {
    }

    public boolean doesBlockDamage(DamageSource src, HeartContainer hc) {
        return false;
    }

    public int adjustFillRate(int fillRate) {
        return fillRate;
    }

    public ResourceLocation getTexture() {
        return this.tex;
    }

    public float getMinU() {
        return (float)this.u / (float)this.texWidth;
    }

    public float getMaxU() {
        return (float)(this.u + this.width) / (float)this.texWidth;
    }

    public float getMinV() {
        return (float)this.v / (float)this.texHeight;
    }

    public float getMaxV() {
        return (float)(this.v + this.height) / (float)this.texHeight;
    }

    public int getTextureWidth() {
        return this.texWidth;
    }

    public int getTextureHeight() {
        return this.texHeight;
    }

    public int getU() {
        return this.u;
    }

    public int getV() {
        return this.v;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static void registerGemRegistry() {
        REGISTRY = (ForgeRegistry)new RegistryBuilder().setIDRange(0, 254).setName(new ResourceLocation("glasshearts", "gems")).setType(Gem.class).setDefaultKey(new ResourceLocation("glasshearts", "none")).create();
    }

    public static void registerGems() {
        Gem[] gemArray = new Gem[11];
        Gems.NONE = new GemNone();
        gemArray[0] = (Gem)Gems.NONE.setRegistryName("none");
        Gems.AGATE = new GemAgate();
        gemArray[1] = (Gem)Gems.AGATE.setRegistryName("agate");
        Gems.AMBER = new GemAmber();
        gemArray[2] = (Gem)Gems.AMBER.setRegistryName("amber");
        Gems.AMETHYST = new GemAmethyst();
        gemArray[3] = (Gem)Gems.AMETHYST.setRegistryName("amethyst");
        Gems.DIAMOND = new GemDiamond();
        gemArray[4] = (Gem)Gems.DIAMOND.setRegistryName("diamond");
        Gems.EMERALD = new GemEmerald();
        gemArray[5] = (Gem)Gems.EMERALD.setRegistryName("emerald");
        Gems.ONYX = new GemOnyx();
        gemArray[6] = (Gem)Gems.ONYX.setRegistryName("onyx");
        Gems.OPAL = new GemOpal();
        gemArray[7] = (Gem)Gems.OPAL.setRegistryName("opal");
        Gems.RUBY = new GemRuby();
        gemArray[8] = (Gem)Gems.RUBY.setRegistryName("ruby");
        Gems.SAPPHIRE = new GemSapphire();
        gemArray[9] = (Gem)Gems.SAPPHIRE.setRegistryName("sapphire");
        Gems.TOPAZ = new GemTopaz();
        gemArray[10] = (Gem)Gems.TOPAZ.setRegistryName("topaz");
        REGISTRY.registerAll((IForgeRegistryEntry[])gemArray);
    }

    static {
        MISSING = new ResourceLocation("glasshearts", "this/definitely/does/not/exist.png");
    }
}

