/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.logic;

import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.logic.BlockHeartContainerOwner;
import com.elytradev.glasshearts.logic.HeartContainerOwner;
import com.elytradev.glasshearts.logic.IGlassHeart;
import com.google.common.base.Enums;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Locale;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class HeartContainer
implements INBTSerializable<NBTTagCompound> {
    public static final BiMap<String, Class<? extends HeartContainerOwner>> REGISTRY = HashBiMap.create();
    private EnumGlassColor glassColor;
    private Gem gem;
    private float fillAmount;
    private float lastFillAmount;
    private HeartContainerOwner owner;
    public int animationTicks;

    public HeartContainer() {
    }

    public HeartContainer(EnumGlassColor glassColor, Gem gem, float fillAmount, HeartContainerOwner owner) {
        if (gem == null) {
            throw new IllegalArgumentException("Null gem is invalid, use Gems.NONE");
        }
        this.glassColor = glassColor;
        this.gem = gem;
        this.fillAmount = fillAmount;
        this.owner = owner;
    }

    public static HeartContainer createNatural(Gem gem, float fillAmount) {
        return new HeartContainer(null, gem, fillAmount, null);
    }

    public static HeartContainer createGlass(EnumGlassColor color, Gem gem, float fillAmount) {
        if (color == null) {
            throw new IllegalArgumentException("Null color is not permitted in createGlass, use the constructor directly or createNatural");
        }
        return new HeartContainer(color, gem, fillAmount, null);
    }

    public static HeartContainer createGlass(IGlassHeart igh) {
        return new HeartContainer(igh.getColor(), igh.getGem(), (float)igh.getLifeforce() / (float)igh.getLifeforceCapacity(), new BlockHeartContainerOwner(igh.getHeartWorld(), igh.getHeartPos()));
    }

    public boolean canHeal() {
        return this.glassColor == null;
    }

    public float damage(float amount, DamageSource src) {
        if (this.fillAmount <= 0.0f) {
            return 0.0f;
        }
        float mult = this.gem.getMultiplier(src);
        if (amount * mult > this.fillAmount && this.gem.doesBlockDamage(src, this)) {
            this.fillAmount = 0.0f;
            if (this.hasOwner()) {
                this.getOwner().set(0.0f);
            }
            return amount;
        }
        float dmg = Math.min(amount *= mult, this.fillAmount);
        this.fillAmount -= dmg;
        if (this.hasOwner()) {
            this.getOwner().modify(-dmg);
        }
        return dmg / mult;
    }

    public float heal(float amount) {
        if (!this.canHeal()) {
            return 0.0f;
        }
        float heal = Math.min(amount, 1.0f - this.fillAmount);
        this.fillAmount += heal;
        if (this.hasOwner()) {
            this.getOwner().modify(heal);
        }
        return heal;
    }

    public float getFillAmount() {
        return this.fillAmount;
    }

    public float getLastFillAmount() {
        return this.lastFillAmount;
    }

    public Gem getGem() {
        return this.gem;
    }

    public EnumGlassColor getGlassColor() {
        return this.glassColor;
    }

    public HeartContainerOwner getOwner() {
        return this.owner;
    }

    public void setFillAmount(float fillAmount) {
        this.fillAmount = fillAmount;
    }

    public void setLastFillAmount(float lastFillAmount) {
        this.lastFillAmount = lastFillAmount;
    }

    public void setGem(Gem gem) {
        if (gem == null) {
            throw new IllegalArgumentException("Null gem is invalid, use Gems.NONE");
        }
        this.gem = gem;
    }

    public void setGlassColor(EnumGlassColor glassColor) {
        this.glassColor = glassColor;
    }

    public void setOwner(HeartContainerOwner owner) {
        this.owner = owner;
    }

    public HeartContainer copy() {
        return new HeartContainer(this.glassColor, this.gem, this.fillAmount, this.owner == null ? null : this.owner.copy());
    }

    public int getFillAmountInt() {
        return (int)(this.fillAmount * 255.0f) & 0xFF;
    }

    public byte getFillAmountByte() {
        return (byte)this.getFillAmountInt();
    }

    public void setFillAmountInt(int fillAmount) {
        this.setFillAmount((float)(fillAmount & 0xFF) / 255.0f);
    }

    public void setFillAmountByte(byte fillAmount) {
        this.setFillAmountInt(fillAmount & 0xFF);
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public String toString() {
        String gemStr;
        String string = gemStr = this.gem == Gems.NONE ? "" : "+" + this.gem.getRegistryName().func_110623_a();
        if (this.glassColor == null) {
            return "natural" + gemStr + "[" + this.fillAmount + "]";
        }
        if (this.glassColor == EnumGlassColor.NONE) {
            return "glass" + gemStr + "[" + this.fillAmount + "]";
        }
        return this.glassColor.func_176610_l() + "_glass" + gemStr + "[" + this.fillAmount + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getFillAmountInt();
        result = 31 * result + (this.gem == null ? 0 : ((Object)((Object)this.gem)).hashCode());
        result = 31 * result + (this.glassColor == null ? 0 : this.glassColor.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeartContainer that = (HeartContainer)obj;
        if (this.getFillAmountInt() != that.getFillAmountInt()) {
            return false;
        }
        if (this.gem != that.gem) {
            return false;
        }
        if (this.glassColor != that.glassColor) {
            return false;
        }
        return Objects.equal((Object)this.owner, (Object)that.owner);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        String gemStr;
        this.glassColor = (EnumGlassColor)((Object)Enums.getIfPresent(EnumGlassColor.class, (String)nbt.func_74779_i("Color").toUpperCase(Locale.ROOT)).orNull());
        String string = gemStr = nbt.func_150297_b("Gem", 8) ? nbt.func_74779_i("Gem") : "glasshearts:none";
        if (!gemStr.contains(":")) {
            gemStr = "glasshearts:" + gemStr;
        }
        this.gem = (Gem)Gem.REGISTRY.getValue(new ResourceLocation(gemStr));
        this.setFillAmountByte(nbt.func_74771_c("Fill"));
        this.lastFillAmount = this.fillAmount;
        if (nbt.func_150297_b("Owner", 10)) {
            NBTTagCompound ownerTag = nbt.func_74775_l("Owner");
            try {
                HeartContainerOwner ihco = (HeartContainerOwner)((Class)REGISTRY.get((Object)ownerTag.func_74779_i("Kind"))).newInstance();
                ihco.deserializeNBT((NBTBase)ownerTag);
                this.owner = ihco;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.owner = null;
            }
        } else {
            this.owner = null;
        }
    }

    public static HeartContainer createFromNBT(NBTTagCompound nbt) {
        HeartContainer hc = new HeartContainer(null, Gems.NONE, 0.0f, null);
        hc.deserializeNBT(nbt);
        return hc;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.glassColor != null) {
            tag.func_74778_a("Color", this.glassColor.func_176610_l());
        }
        if (this.gem != Gems.NONE) {
            tag.func_74778_a("Gem", this.gem.getRegistryName().toString());
        }
        tag.func_74774_a("Fill", this.getFillAmountByte());
        if (this.owner != null) {
            NBTTagCompound ownerTag = (NBTTagCompound)this.owner.serializeNBT();
            ownerTag.func_74778_a("Kind", (String)REGISTRY.inverse().get(this.owner.getClass()));
            tag.func_74782_a("Owner", (NBTBase)ownerTag);
        }
        return tag;
    }

    static {
        REGISTRY.put((Object)"block", BlockHeartContainerOwner.class);
    }
}

