/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.repackage.com.elytradev.concrete.network;

import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.annotation.type.Asynchronous;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.annotation.type.ReceivedOn;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.exception.BadMessageException;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.exception.WrongSideException;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Message {
    private static final Map<Class<?>, ClassInfo> classInfo = Maps.newHashMap();
    private final transient NetworkContext ctx;
    private final transient Side side;
    private final transient boolean async;

    public Message(NetworkContext ctx) {
        this.ctx = ctx;
        ClassInfo ci = classInfo.get(this.getClass());
        if (ci == null) {
            ReceivedOn ro = this.getClass().getDeclaredAnnotation(ReceivedOn.class);
            if (ro == null) {
                throw new BadMessageException("Must specify @ReceivedOn");
            }
            this.side = ro.value();
            this.async = this.getClass().getDeclaredAnnotation(Asynchronous.class) != null;
            classInfo.put(this.getClass(), new ClassInfo(this.async, this.side));
        } else {
            this.async = ci.async;
            this.side = ci.side;
        }
    }

    @SideOnly(value=Side.CLIENT)
    void doHandleClient() {
        if (this.async) {
            this.handle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        } else {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    Message.this.handle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                }
            });
        }
    }

    void doHandleServer(EntityPlayer sender) {
        if (this.async) {
            this.handle(sender);
        } else {
            ((WorldServer)sender.field_70170_p).func_152344_a(() -> this.handle(sender));
        }
    }

    protected abstract void handle(EntityPlayer var1);

    Side getSide() {
        return this.side;
    }

    public final void sendTo(EntityPlayer player) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        if (player instanceof EntityPlayerMP) {
            for (Packet<INetHandlerPlayClient> p : this.toClientboundVanillaPackets()) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a(p);
            }
        }
    }

    public final void sendToAllAround(World world, Entity entity, double radius) {
        this.sendToAllAroundExcept(world, entity, radius, null);
    }

    public final void sendToAllAround(World world, Vec3i pos, double radius) {
        this.sendToAllAroundExcept(world, pos, radius, null);
    }

    public final void sendToAllAround(World world, Vec3d pos, double radius) {
        this.sendToAllAroundExcept(world, pos, radius, null);
    }

    public final void sendToAllAround(World world, double x, double y, double z, double radius) {
        this.sendToAllAroundExcept(world, x, y, z, radius, null);
    }

    public final void sendToAllAroundExcept(World world, Entity entity, double radius, @Nullable EntityPlayer exclude) {
        this.sendToAllAroundExcept(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, radius, exclude);
    }

    public final void sendToAllAroundExcept(World world, Vec3i pos, double radius, @Nullable EntityPlayer exclude) {
        this.sendToAllAroundExcept(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, radius, exclude);
    }

    public final void sendToAllAroundExcept(World world, Vec3d pos, double radius, @Nullable EntityPlayer exclude) {
        this.sendToAllAroundExcept(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, radius, exclude);
    }

    public final void sendToAllAroundExcept(World world, double x, double y, double z, double radius, @Nullable EntityPlayer exclude) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        double sq = radius * radius;
        List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
            if (ep == exclude || !(ep.func_70092_e(x, y, z) <= sq)) continue;
            for (Packet<INetHandlerPlayClient> packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public final void sendToAllWatching(World world, BlockPos pos) {
        this.sendToAllWatchingExcept(world, pos, null);
    }

    public final void sendToAllWatchingExcept(World world, BlockPos pos, @Nullable EntityPlayer exclude) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        if (world instanceof WorldServer) {
            WorldServer srv = (WorldServer)world;
            Chunk c = srv.func_175726_f(pos);
            if (srv.func_184164_w().func_152621_a(c.field_76635_g, c.field_76647_h)) {
                List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
                for (EntityPlayerMP ep : world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
                    if (ep == exclude || !srv.func_184164_w().func_72694_a(ep, c.field_76635_g, c.field_76647_h)) continue;
                    for (Packet<INetHandlerPlayClient> packet : packets) {
                        ep.field_71135_a.func_147359_a(packet);
                    }
                }
            }
        }
    }

    public final void sendToAllWatching(TileEntity te) {
        this.sendToAllWatchingExcept(te, null);
    }

    public final void sendToAllWatchingExcept(TileEntity te, @Nullable EntityPlayer exclude) {
        this.sendToAllWatchingExcept(te.func_145831_w(), te.func_174877_v(), exclude);
    }

    public final void sendToAllWatching(Entity e) {
        this.sendToAllWatchingExcept(e, null);
    }

    public final void sendToAllWatchingExcept(Entity e, @Nullable EntityPlayer exclude) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        if (e.field_70170_p instanceof WorldServer) {
            WorldServer srv = (WorldServer)e.field_70170_p;
            List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
            for (EntityPlayer ep : srv.func_73039_n().getTrackingPlayers(e)) {
                if (ep == exclude || !(ep instanceof EntityPlayerMP)) continue;
                for (Packet<INetHandlerPlayClient> packet : packets) {
                    ((EntityPlayerMP)ep).field_71135_a.func_147359_a(packet);
                }
            }
        }
    }

    public final void sendToAllWatchingAndSelf(Entity e) {
        this.sendToAllWatchingAndSelfExcept(e, null);
    }

    public final void sendToAllWatchingAndSelfExcept(Entity e, @Nullable EntityPlayer exclude) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        if (e.field_70170_p instanceof WorldServer) {
            WorldServer srv = (WorldServer)e.field_70170_p;
            List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
            for (EntityPlayer entityPlayer : srv.func_73039_n().getTrackingPlayers(e)) {
                if (entityPlayer == exclude || !(entityPlayer instanceof EntityPlayerMP)) continue;
                for (Packet<INetHandlerPlayClient> packet : packets) {
                    ((EntityPlayerMP)entityPlayer).field_71135_a.func_147359_a(packet);
                }
            }
            if (e instanceof EntityPlayerMP) {
                for (Packet packet : packets) {
                    ((EntityPlayerMP)e).field_71135_a.func_147359_a(packet);
                }
            }
        }
    }

    public final void sendToAllIn(World world) {
        this.sendToAllInExcept(world, null);
    }

    public final void sendToAllInExcept(World world, @Nullable EntityPlayer exclude) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
            if (ep == exclude) continue;
            for (Packet<INetHandlerPlayClient> packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public final void sendToEveryone() {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            for (Packet<INetHandlerPlayClient> packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void sendToServer() {
        NetHandlerPlayClient conn;
        if (this.side.isClient()) {
            this.wrongSide();
        }
        if ((conn = Minecraft.func_71410_x().func_147114_u()) == null) {
            throw new IllegalStateException("Cannot send a message while not connected");
        }
        conn.func_147297_a(this.toServerboundVanillaPacket());
    }

    public final Packet<INetHandlerPlayServer> toServerboundVanillaPacket() {
        return this.ctx.getPacketFrom(this).toC17Packet();
    }

    public final List<Packet<INetHandlerPlayClient>> toClientboundVanillaPackets() {
        try {
            return this.ctx.getPacketFrom(this).toS3FPackets();
        }
        catch (IOException e) {
            throw new BadMessageException(e);
        }
    }

    private void wrongSide() {
        throw new WrongSideException(this.getClass() + " cannot be sent from side " + this.side);
    }

    private static final class ClassInfo {
        public final boolean async;
        public final Side side;

        public ClassInfo(boolean async, Side side) {
            this.async = async;
            this.side = side;
        }
    }
}

