/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.repackage.com.elytradev.concrete.network;

import com.elytradev.glasshearts.repackage.com.elytradev.concrete.common.ConcreteLog;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.common.ShadingValidator;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.WireField;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.annotation.field.Optional;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.exception.BadMessageException;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.network.exception.WrongSideException;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.reflect.instanciator.Instanciator;
import com.elytradev.glasshearts.repackage.com.elytradev.concrete.reflect.instanciator.Instanciators;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class NetworkContext {
    protected static final Map<Class<? extends Message>, Instanciator<? extends Message>> instanciators;
    protected final BiMap<Class<? extends Message>, Integer> packetIds = HashBiMap.create();
    protected final Map<Class<? extends Message>, List<WireField<?>>> marshallers = Maps.newHashMap();
    protected final Multiset<Class<? extends Message>> booleanCount = HashMultiset.create();
    protected final Multiset<Class<? extends Message>> optionalCount = HashMultiset.create();
    protected final String channel;
    private int nextPacketId = 0;

    private NetworkContext(String channel) {
        this.channel = channel;
        NetworkRegistry.INSTANCE.newEventDrivenChannel(channel).register((Object)this);
    }

    public NetworkContext register(Class<? extends Message> clazz) {
        if (this.packetIds.containsKey(clazz)) {
            ConcreteLog.warn("{} was registered twice", clazz);
            return this;
        }
        this.packetIds.put(clazz, (Object)this.nextPacketId++);
        ArrayList fields = Lists.newArrayList();
        for (Class<? extends Message> cursor = clazz; cursor != null && cursor != Object.class; cursor = cursor.getSuperclass()) {
            for (Field f : cursor.getDeclaredFields()) {
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                if (f.getType() == Boolean.TYPE) {
                    this.booleanCount.add(clazz);
                }
                if (f.getAnnotation(Optional.class) != null) {
                    this.optionalCount.add(clazz);
                }
                WireField wf = new WireField(f);
                fields.add(wf);
            }
        }
        this.marshallers.put(clazz, fields);
        return this;
    }

    public String getChannel() {
        return this.channel;
    }

    protected FMLProxyPacket getPacketFrom(Message m) {
        if (!this.packetIds.containsKey(m.getClass())) {
            throw new BadMessageException(m.getClass() + " is not registered");
        }
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer());
        payload.writeByte(((Integer)this.packetIds.get(m.getClass())).intValue());
        int bools = this.booleanCount.count(m.getClass()) + this.optionalCount.count(m.getClass());
        if (bools > 0) {
            ArrayList li = Lists.newArrayListWithCapacity((int)bools);
            for (WireField<?> wf : this.marshallers.get(m.getClass())) {
                if (wf.getType() == Boolean.TYPE) {
                    li.add((Boolean)wf.get(m));
                    continue;
                }
                if (!wf.isOptional()) continue;
                li.add(wf.get(m) != null);
            }
            for (int i = 0; i < (bools + 7) / 8; ++i) {
                int by = 0;
                for (int j = i * 8; j < Math.min(li.size(), i + 8); ++j) {
                    if (!((Boolean)li.get(j)).booleanValue()) continue;
                    by |= 1 << j;
                }
                payload.writeByte(by);
            }
        }
        this.marshallers.get(m.getClass()).stream().filter(it -> it.getType() != Boolean.TYPE).forEach(it -> it.marshal(m, (ByteBuf)payload));
        return new FMLProxyPacket(payload, this.channel);
    }

    @SubscribeEvent
    public void onServerCustomPacket(FMLNetworkEvent.ServerCustomPacketEvent e) {
        ByteBuf payload = e.getPacket().payload();
        Message m = this.readPacket(e.side(), payload);
        m.doHandleServer((EntityPlayer)((NetHandlerPlayServer)e.getHandler()).field_147369_b);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientCustomPacket(FMLNetworkEvent.ClientCustomPacketEvent e) {
        ByteBuf payload = e.getPacket().payload();
        Message m = this.readPacket(e.side(), payload);
        m.doHandleClient();
    }

    private Message readPacket(Side side, ByteBuf payload) {
        Message m;
        short id = payload.readUnsignedByte();
        if (!this.packetIds.containsValue((Object)id)) {
            throw new IllegalArgumentException("Unknown packet id " + id);
        }
        Class clazz = (Class)this.packetIds.inverse().get((Object)id);
        try {
            m = this.instantiateMessage(clazz);
        }
        catch (Throwable t) {
            throw new BadMessageException("Cannot instanciate message class " + clazz, t);
        }
        if (m.getSide() != side) {
            throw new WrongSideException("Cannot receive packet of type " + clazz + " on side " + side);
        }
        HashSet present = Sets.newHashSetWithExpectedSize((int)this.marshallers.get(m.getClass()).size());
        int bools = this.booleanCount.count(m.getClass()) + this.optionalCount.count(m.getClass());
        if (bools > 0) {
            ArrayList li = Lists.newArrayListWithCapacity((int)bools);
            for (WireField<?> wf : this.marshallers.get(m.getClass())) {
                if (wf.getType() == Boolean.TYPE) {
                    li.add(b -> wf.set(m, b));
                    present.add(wf);
                    continue;
                }
                if (wf.isOptional()) {
                    li.add(b -> {
                        if (b.booleanValue()) {
                            present.add(wf);
                        }
                    });
                    continue;
                }
                present.add(wf);
            }
            for (int i = 0; i < (bools + 7) / 8; ++i) {
                short by = payload.readUnsignedByte();
                for (int j = i * 8; j < Math.min(li.size(), i + 8); ++j) {
                    boolean val = (by & 1 << j - i) != 0;
                    ((Consumer)li.get(j)).accept(val);
                }
            }
        } else {
            present.addAll((Collection)this.marshallers.get(m.getClass()));
        }
        this.marshallers.get(m.getClass()).stream().filter(it -> it.getType() != Boolean.TYPE && present.contains(it)).forEach(it -> it.unmarshal(m, payload));
        return m;
    }

    private Message instantiateMessage(Class<? extends Message> clazz) throws Throwable {
        Instanciator<? extends Message> instanciator = instanciators.get(clazz);
        if (instanciator == null) {
            Constructor<? extends Message> cons;
            try {
                cons = clazz.getDeclaredConstructor(NetworkContext.class);
            }
            catch (Throwable t) {
                cons = clazz.getDeclaredConstructor(new Class[0]);
            }
            instanciator = Instanciators.from(cons);
            instanciators.put(clazz, instanciator);
        }
        try {
            return instanciator.newInstance(this);
        }
        catch (Throwable t) {
            return instanciator.newInstance(new Object[0]);
        }
    }

    public static NetworkContext forChannel(String channel) {
        if (channel.length() > 20) {
            throw new IllegalArgumentException("Channel name too long, must be at most 20 characters");
        }
        return new NetworkContext(channel);
    }

    static {
        ShadingValidator.ensureShaded();
        instanciators = Maps.newHashMap();
    }
}

