/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.world;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.enums.EnumGemOre;
import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.logic.IGlassHeart;
import com.elytradev.glasshearts.world.GlassHeartWorldData;
import com.google.common.base.Enums;
import java.util.Locale;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class GlassHeartData
implements INBTSerializable<NBTTagCompound>,
IGlassHeart {
    private GlassHeartWorldData parent;
    private BlockPos pos;
    private EnumGlassColor color;
    private ItemStack gemStack;
    private int lifeforce;
    private int lifeforceBuffer;
    private boolean hasBeenFull;
    private transient Gem gem = Gems.NONE;

    public GlassHeartData(GlassHeartWorldData parent) {
        this.parent = parent;
    }

    public GlassHeartData(GlassHeartWorldData parent, BlockPos pos, EnumGlassColor color, ItemStack gemStack, int lifeforce, int lifeforceBuffer) {
        this.parent = parent;
        this.pos = pos;
        this.color = color;
        this.gemStack = gemStack;
        this.lifeforce = lifeforce;
        this.lifeforceBuffer = lifeforceBuffer;
        this.gem = Gem.fromItemStack(gemStack);
    }

    @Override
    public EnumGlassColor getColor() {
        return this.color;
    }

    @Override
    public Gem getGem() {
        return this.gem;
    }

    @Override
    public ItemStack getGemStack() {
        return this.gemStack;
    }

    @Override
    public int getLifeforce() {
        return this.lifeforce;
    }

    @Override
    public BlockPos getHeartPos() {
        return this.pos;
    }

    @Override
    public int getLifeforceBuffer() {
        return this.lifeforceBuffer;
    }

    @Override
    public int getLifeforceCapacity() {
        return GlassHearts.inst.configGlassHeartCapacity;
    }

    @Override
    public boolean hasBeenFull() {
        return this.hasBeenFull;
    }

    @Override
    public World getHeartWorld() {
        return this.parent.getWorld();
    }

    @Override
    public void setColor(EnumGlassColor color) {
        this.color = color;
        this.parent.func_76185_a();
    }

    @Override
    public void setGemStack(ItemStack gemStack) {
        this.gemStack = gemStack;
        this.gem = Gem.fromItemStack(gemStack);
        this.parent.func_76185_a();
    }

    @Override
    public void setLifeforce(int lifeforce) {
        this.lifeforce = lifeforce;
        this.parent.func_76185_a();
    }

    @Override
    public void setHasBeenFull(boolean hasBeenFull) {
        this.hasBeenFull = hasBeenFull;
        this.parent.func_76185_a();
    }

    public void setHeartPos(BlockPos pos) {
        this.pos = pos;
        this.parent.func_76185_a();
    }

    @Override
    public void setLifeforceBuffer(int lifeforceBuffer) {
        this.lifeforceBuffer = lifeforceBuffer;
        this.parent.func_76185_a();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.pos = BlockPos.func_177969_a((long)nbt.func_74763_f("Pos"));
        this.color = (EnumGlassColor)((Object)Enums.getIfPresent(EnumGlassColor.class, (String)nbt.func_74779_i("Color").toUpperCase(Locale.ROOT)).or((Object)EnumGlassColor.NONE));
        if (nbt.func_150297_b("Gem", 8)) {
            this.gem = (Gem)Gem.REGISTRY.getValue(new ResourceLocation("glasshearts", nbt.func_74779_i("Gem").toLowerCase(Locale.ROOT)));
            if (this.gem == null) {
                this.gem = Gems.NONE;
            }
            this.gemStack = this.gem == Gems.NONE ? ItemStack.field_190927_a : (this.gem == Gems.DIAMOND ? new ItemStack(Items.field_151045_i, 1, 0) : (this.gem == Gems.EMERALD ? new ItemStack(Items.field_151166_bC, 1, 0) : new ItemStack((Item)GlassHearts.inst.GEM, 1, EnumGemOre.valueOf(this.gem.getRegistryName().func_110623_a().toUpperCase(Locale.ROOT)).ordinal())));
        } else {
            this.gemStack = new ItemStack(nbt.func_74775_l("GemStack"));
            this.gem = Gem.fromItemStack(this.gemStack);
        }
        this.lifeforce = Math.max(0, Math.min(nbt.func_74765_d("Lifeforce"), this.getLifeforceCapacity()));
        this.lifeforceBuffer = Math.max(0, Math.min(nbt.func_74765_d("LifeforceBuffer"), this.getLifeforceCapacity() - this.lifeforce));
        this.hasBeenFull = nbt.func_74767_n("HasBeenFull");
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("Pos", this.pos.func_177986_g());
        tag.func_74778_a("Color", this.color.func_176610_l());
        tag.func_74782_a("GemStack", (NBTBase)this.gemStack.serializeNBT());
        tag.func_74777_a("Lifeforce", (short)this.lifeforce);
        tag.func_74777_a("LifeforceBuffer", (short)this.lifeforceBuffer);
        tag.func_74757_a("HasBeenFull", this.hasBeenFull);
        return tag;
    }
}

