/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts;

import com.elytradev.glasshearts.GlassHearts$$Lambda$1;
import com.elytradev.glasshearts.Proxy;
import com.elytradev.glasshearts.block.BlockFluidLifeforce;
import com.elytradev.glasshearts.block.BlockGlassHeart;
import com.elytradev.glasshearts.block.BlockOre;
import com.elytradev.glasshearts.block.BlockPetrifiedLog;
import com.elytradev.glasshearts.capability.CapabilityHeartHandler;
import com.elytradev.glasshearts.capability.EntityHeartHandler;
import com.elytradev.glasshearts.capability.IHeartHandler;
import com.elytradev.glasshearts.enchant.EnchantmentSapping;
import com.elytradev.glasshearts.entity.EntityAICreeperSeekHeart;
import com.elytradev.glasshearts.enums.EnumGemOre;
import com.elytradev.glasshearts.enums.EnumGemState;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.integration.tcon.TConIntegration;
import com.elytradev.glasshearts.item.ItemBlockGlassHeart;
import com.elytradev.glasshearts.item.ItemBlockOre;
import com.elytradev.glasshearts.item.ItemGem;
import com.elytradev.glasshearts.item.ItemLifeforceBottle;
import com.elytradev.glasshearts.item.ItemStaff;
import com.elytradev.glasshearts.logic.BlockHeartContainerOwner;
import com.elytradev.glasshearts.logic.HeartContainer;
import com.elytradev.glasshearts.logic.HeartContainerOwner;
import com.elytradev.glasshearts.logic.IGlassHeart;
import com.elytradev.glasshearts.logic.PlayerHandler;
import com.elytradev.glasshearts.network.ParticleEffectMessage;
import com.elytradev.glasshearts.network.PlayHeartEffectMessage;
import com.elytradev.glasshearts.network.UpdateHeartsMessage;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.NetworkContext;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.invoker.Invoker;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.invoker.Invokers;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart;
import com.elytradev.glasshearts.world.GenerateGems;
import com.elytradev.glasshearts.world.GeneratePetrifiedTree;
import com.elytradev.glasshearts.world.GlassHeartData;
import com.elytradev.glasshearts.world.GlassHeartWorldData;
import com.google.common.base.Objects;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.stats.IStatType;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatBasic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="glasshearts", name="Glass Hearts", version="1.10.2-1.0.0")
public class GlassHearts {
    @Mod.Instance
    public static GlassHearts inst;
    public static final Logger LOG;
    public boolean configLifeforceFromPlayerKillsOnly = false;
    public boolean configLifeforceFromUndead = false;
    public boolean configOverrideHealthRenderer = true;
    public int configGlassHeartCapacity = 1000;
    public int configLifeforceBottleSize = 400;
    public int configGlassHeartFillRate = 10;
    public int configMaxContainers = 40;
    public boolean configCreepersSeekHearts = true;
    public boolean configCreeperFakeExplosions = false;
    public boolean configGeneratePetrifiedTrees = true;
    public Set<EnumGemOre> configGenerateGems = EnumSet.allOf(EnumGemOre.class);
    @SidedProxy(clientSide="com.elytradev.glasshearts.client.ClientProxy", serverSide="com.elytradev.glasshearts.CommonProxy")
    public static Proxy proxy;
    public NetworkContext NETWORK;
    public Fluid LIFEFORCE;
    public BlockFluidLifeforce LIFEFORCE_BLOCK;
    public EnchantmentSapping SAPPING;
    public SoundEvent SAP;
    public SoundEvent ATTUNE;
    public ItemLifeforceBottle LIFEFORCE_BOTTLE;
    public ItemGem GEM;
    public ItemStaff STAFF;
    public BlockGlassHeart GLASS_HEART;
    public BlockOre ORE;
    public BlockPetrifiedLog PETRIFIED_LOG;
    public IStatType millibucketStatType = GlassHearts$$Lambda$1.lambdaFactory$();
    public StatBase LIFEFORCE_CONSUMED = new StatBasic("glasshearts:stat.lifeforce_consumed", (ITextComponent)new TextComponentTranslation("stat.glasshearts.lifeforce_consumed", new Object[0]), this.millibucketStatType).func_75966_h().func_75971_g();
    public StatBase LIFEFORCE_COLLECTED = new StatBasic("glasshearts:stat.lifeforce_collected", (ITextComponent)new TextComponentTranslation("stat.glasshearts.lifeforce_collected", new Object[0]), this.millibucketStatType).func_75966_h().func_75971_g();
    public StatBase HEALTH_TRANSFERRED = new StatBasic("glasshearts:stat.health_transferred", (ITextComponent)new TextComponentTranslation("stat.glasshearts.health_transferred", new Object[0]), StatBase.field_75980_h).func_75966_h().func_75971_g();
    public CreativeTabs CREATIVE_TAB = new CreativeTabs("glass_heart"){

        public Item func_78016_d() {
            return Item.func_150898_a((Block)GlassHearts.this.GLASS_HEART);
        }
    };
    private Invoker rayTrace = Invokers.findMethod(Item.class, null, new String[]{"func_77621_a", "rayTrace", "a"}, World.class, EntityPlayer.class, Boolean.TYPE);
    private Invoker applyArmorCalculations = Invokers.findMethod(EntityLivingBase.class, null, new String[]{"func_70655_b", "applyArmorCalculations", "b"}, DamageSource.class, Float.TYPE);
    private Invoker applyPotionDamageCalculations = Invokers.findMethod(EntityLivingBase.class, null, new String[]{"func_70672_c", "applyPotionDamageCalculations", "c"}, DamageSource.class, Float.TYPE);
    private Invoker explode = Invokers.findMethod(EntityCreeper.class, null, new String[]{"func_146077_cc", "explode", "dn"}, new Class[0]);
    private Map<EntityPlayer, PlayerHandler> playerHandlers = new WeakHashMap<EntityPlayer, PlayerHandler>();

    public GlassHearts() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        Configuration config = new Configuration(e.getSuggestedConfigurationFile());
        this.configLifeforceFromPlayerKillsOnly = config.getBoolean("lifeforceFromPlayerKillsOnly", "Balance", false, "If true, Lifeforce can only be collected from player kills,\nnot mob kills.\n");
        this.configLifeforceFromUndead = config.getBoolean("lifeforceFromUndead", "Balance", false, "If true, Lifeforce can be collected from undead mobs.\nIgnored if lifeforceFromPlayerKillsOnly is true.\n");
        this.configOverrideHealthRenderer = config.getBoolean("overrideHealthRenderer", "Compatibility", true, "If true, the health bar renderer will be overridden.\nRequired for glass outlines and sub-half-heart accuracy.\n");
        this.configGlassHeartCapacity = config.getInt("glassHeartCapacity", "Balance", 8000, 0, Short.MAX_VALUE, "The maximum amount of Lifeforce a glass heart can hold, in mB.\nThis directly corresponds to how much Lifeforce it takes to\nbring a heart container back to full, or fill a new container.\n");
        this.configLifeforceBottleSize = config.getInt("lifeforceBottleSize", "Balance", 400, 0, Integer.MAX_VALUE, "How much Lifeforce is in a Bottle of Lifeforce, in mB.\nYou receive a Bottle of Lifeforce when the Sapping enchant\nprocs.\n");
        this.configGlassHeartFillRate = config.getInt("glassHeartFillRate", "Balance", 10, 1, Short.MAX_VALUE, "The maximum amount of Lifeforce transferred from the buffer\ntank to the main tank every tick. Keeping this low prevents\nplayers from becoming invincible by refilling their glass\nhearts quickly.\n");
        this.configMaxContainers = config.getInt("maxContainers", "Balance", 40, 1, Short.MAX_VALUE, "The maximum amount of heart containers one player can have.\nThis includes the 10 vanilla hearts.\n");
        this.configCreepersSeekHearts = config.getBoolean("creepersSeekHearts", "Balance", true, "If true, Creepers will seek out Glass Hearts and explode on\nthem. If mobGriefing is false, the heart will still be\ndestroyed, but no nearby blocks will be.\n");
        this.configCreeperFakeExplosions = config.getBoolean("creeperFakeExplosions", "Balance", false, "If true, Creepers exploding on Glass Hearts will only\ndestroy the heart, even if mobGriefing is true.\n");
        this.configGeneratePetrifiedTrees = config.getBoolean("generatePetrifiedTrees", "World", true, "If true, Petrified Trees will generate in forests, which can\nbe broken for amber and sticks.\n");
        this.configGenerateGems.clear();
        if (config.getBoolean("generateAmethystOre", "World", true, "")) {
            this.configGenerateGems.add(EnumGemOre.AMETHYST);
        }
        if (config.getBoolean("generateRubyOre", "World", true, "")) {
            this.configGenerateGems.add(EnumGemOre.RUBY);
        }
        if (config.getBoolean("generateTopazOre", "World", true, "")) {
            this.configGenerateGems.add(EnumGemOre.TOPAZ);
        }
        if (config.getBoolean("generateSapphireOre", "World", true, "")) {
            this.configGenerateGems.add(EnumGemOre.SAPPHIRE);
        }
        if (config.getBoolean("generateOpalOre", "World", true, "")) {
            this.configGenerateGems.add(EnumGemOre.OPAL);
        }
        if (config.getBoolean("generateOnyxOre", "World", true, "")) {
            this.configGenerateGems.add(EnumGemOre.ONYX);
        }
        if (config.getBoolean("generateAgateOre", "World", true, "")) {
            this.configGenerateGems.add(EnumGemOre.AGATE);
        }
        config.save();
        this.NETWORK = NetworkContext.forChannel("gh");
        this.NETWORK.register(ParticleEffectMessage.class);
        this.NETWORK.register(UpdateHeartsMessage.class);
        this.NETWORK.register(PlayHeartEffectMessage.class);
        CapabilityHeartHandler.register();
        Gem.registerGems();
        this.LIFEFORCE = new Fluid("glasshearts.lifeforce", new ResourceLocation("glasshearts", "blocks/lifeforce_still"), new ResourceLocation("glasshearts", "blocks/lifeforce_flow"));
        this.LIFEFORCE.setViscosity(750);
        FluidRegistry.registerFluid((Fluid)this.LIFEFORCE);
        this.LIFEFORCE_BLOCK = new BlockFluidLifeforce(this.LIFEFORCE, Material.field_151586_h);
        this.LIFEFORCE.setBlock((Block)this.LIFEFORCE_BLOCK);
        FluidRegistry.addBucketForFluid((Fluid)this.LIFEFORCE);
        this.LIFEFORCE_BLOCK.setRegistryName("lifeforce_block");
        GameRegistry.register((IForgeRegistryEntry)this.LIFEFORCE_BLOCK);
        this.SAPPING = new EnchantmentSapping();
        this.SAPPING.setRegistryName("sapping");
        GameRegistry.register((IForgeRegistryEntry)this.SAPPING);
        this.LIFEFORCE_BOTTLE = new ItemLifeforceBottle();
        this.LIFEFORCE_BOTTLE.setRegistryName("lifeforce_bottle");
        this.LIFEFORCE_BOTTLE.func_77637_a(this.CREATIVE_TAB);
        GameRegistry.register((IForgeRegistryEntry)this.LIFEFORCE_BOTTLE);
        this.GEM = new ItemGem();
        this.GEM.setRegistryName("gem");
        this.GEM.func_77637_a(this.CREATIVE_TAB);
        GameRegistry.register((IForgeRegistryEntry)this.GEM);
        for (int i = 0; i < EnumGemOre.VALUES.length; ++i) {
            EnumGemOre gem = EnumGemOre.VALUES[i];
            OreDictionary.registerOre((String)("gem" + gem.name().charAt(0) + gem.func_176610_l().substring(1)), (ItemStack)new ItemStack((Item)this.GEM, 1, i));
        }
        this.STAFF = new ItemStaff();
        this.STAFF.setRegistryName("staff");
        this.STAFF.func_77637_a(this.CREATIVE_TAB);
        GameRegistry.register((IForgeRegistryEntry)this.STAFF);
        this.GLASS_HEART = new BlockGlassHeart();
        this.GLASS_HEART.setRegistryName("glass_heart");
        this.GLASS_HEART.func_149647_a(this.CREATIVE_TAB);
        this.GLASS_HEART.func_149663_c("glasshearts.glass_heart");
        GameRegistry.register((IForgeRegistryEntry)this.GLASS_HEART);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockGlassHeart(this.GLASS_HEART).setRegistryName("glass_heart"));
        this.ORE = new BlockOre();
        this.ORE.setRegistryName("ore");
        this.ORE.func_149647_a(this.CREATIVE_TAB);
        this.ORE.func_149663_c("glasshearts.ore");
        GameRegistry.register((IForgeRegistryEntry)this.ORE);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockOre(this.ORE).setRegistryName("ore"));
        this.PETRIFIED_LOG = new BlockPetrifiedLog();
        this.PETRIFIED_LOG.setRegistryName("petrified_log");
        this.PETRIFIED_LOG.func_149647_a(this.CREATIVE_TAB);
        this.PETRIFIED_LOG.func_149663_c("glasshearts.petrified_log");
        GameRegistry.register((IForgeRegistryEntry)this.PETRIFIED_LOG);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this.PETRIFIED_LOG).setRegistryName("petrified_log"));
        this.SAP = new SoundEvent(new ResourceLocation("glasshearts", "sap"));
        this.SAP.setRegistryName("sap");
        GameRegistry.register((IForgeRegistryEntry)this.SAP);
        this.ATTUNE = new SoundEvent(new ResourceLocation("glasshearts", "attune"));
        this.ATTUNE.setRegistryName("attune");
        GameRegistry.register((IForgeRegistryEntry)this.ATTUNE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenerateGems(), (int)2);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this.STAFF, new Object[]{"  o", " //", "/  ", Character.valueOf('/'), Items.field_151072_bj, Character.valueOf('o'), "gemOpal"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)this.GLASS_HEART, 1, 0), new Object[]{"g g", "ggg", " g ", Character.valueOf('g'), "blockGlassColorless"}));
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < dyes.length; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)this.GLASS_HEART, 1, 16 - i), new Object[]{"g g", "ggg", " g ", Character.valueOf('g'), "blockGlass" + dyes[i]}));
        }
        GameRegistry.registerTileEntity(TileEntityGlassHeart.class, (String)"glasshearts:glass_heart");
        if (Loader.isModLoaded((String)"tconstruct")) {
            TConIntegration.init();
        }
        proxy.onPreInit();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        proxy.onPostInit();
    }

    @SubscribeEvent
    public void onNewRegistry(RegistryEvent.NewRegistry e) {
        Gem.registerGemRegistry();
    }

    @SubscribeEvent
    public void onPopulate(ChunkGeneratorEvent.ReplaceBiomeBlocks e) {
        if (e.getWorld().field_73011_w.func_76569_d() && this.configGeneratePetrifiedTrees) {
            GeneratePetrifiedTree.generate(e.getWorld().func_72905_C() + (long)(e.getX() ^ e.getZ()), e.getPrimer(), e.getGen());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLogIn(PlayerEvent.PlayerLoggedInEvent e) {
        PlayerHandler ph = new PlayerHandler(e.player);
        this.playerHandlers.put(e.player, ph);
        ph.resync();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        PlayerHandler ph = new PlayerHandler(e.player);
        this.playerHandlers.put(e.player, ph);
        ph.resync();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHurt(LivingHurtEvent e) {
        float amt = e.getAmount();
        if (e.getEntityLiving().hasCapability(CapabilityHeartHandler.CAPABILITY, null)) {
            IHeartHandler cap = (IHeartHandler)e.getEntityLiving().getCapability(CapabilityHeartHandler.CAPABILITY, null);
            amt = ((Float)this.applyArmorCalculations.invoke(e.getEntityLiving(), e.getSource(), Float.valueOf(amt))).floatValue();
            amt = ((Float)this.applyPotionDamageCalculations.invoke(e.getEntityLiving(), e.getSource(), Float.valueOf(amt))).floatValue();
            if (amt != 0.0f) {
                e.getEntityLiving().func_110142_aN().func_94547_a(e.getSource(), cap.totalHealth() * 2.0f, amt);
                float absorb = Math.min(amt, e.getEntityLiving().func_110139_bj());
                e.getEntityLiving().func_110149_m(e.getEntityLiving().func_110139_bj() - absorb);
                cap.damage((amt -= absorb) / 2.0f, e.getSource());
            }
            e.getEntityLiving().func_70606_j((float)((int)(cap.totalHealth() * 2.0f)));
            e.setAmount(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHeal(LivingHealEvent e) {
        if (e.getEntityLiving().hasCapability(CapabilityHeartHandler.CAPABILITY, null)) {
            float waste;
            float amt;
            IHeartHandler cap = (IHeartHandler)e.getEntityLiving().getCapability(CapabilityHeartHandler.CAPABILITY, null);
            float taken = cap.heal(amt = e.getAmount() / 2.0f);
            if (taken < amt && (waste = amt - taken) >= 0.5f && e.getEntityLiving() instanceof EntityPlayer) {
                new PlayHeartEffectMessage(2, (int)(waste * 2.0f) - 1, cap.getContainers() - 1).sendTo((EntityPlayer)e.getEntityLiving());
            }
            e.getEntityLiving().func_70606_j((float)((int)(cap.totalHealth() * 2.0f)));
            e.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public void onExplode(ExplosionEvent.Detonate e) {
        EntityCreeper ec;
        if (e.getExplosion().func_94613_c() instanceof EntityCreeper && (ec = (EntityCreeper)e.getExplosion().func_94613_c()).func_184216_O().contains("glasshearts:found_heart") && (this.configCreeperFakeExplosions || !e.getWorld().func_82736_K().func_82766_b("mobGriefing"))) {
            Iterator iter = e.getAffectedBlocks().iterator();
            while (iter.hasNext()) {
                BlockPos pos = (BlockPos)iter.next();
                if (e.getWorld().func_180495_p(pos).func_177230_c() == this.GLASS_HEART) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start e) {
        EntityCreeper ec;
        if (e.getExplosion().func_94613_c() instanceof EntityCreeper && (ec = (EntityCreeper)e.getExplosion().func_94613_c()).func_184216_O().contains("glasshearts:found_heart") && !e.getWorld().func_82736_K().func_82766_b("mobGriefing")) {
            e.setCanceled(true);
            boolean oldFakeExplosions = this.configCreeperFakeExplosions;
            try {
                e.getWorld().func_82736_K().func_82764_b("mobGriefing", "true");
                this.configCreeperFakeExplosions = true;
                this.explode.invoke(ec, new Object[0]);
            }
            finally {
                e.getWorld().func_82736_K().func_82764_b("mobGriefing", "false");
                this.configCreeperFakeExplosions = oldFakeExplosions;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSave(PlayerEvent.SaveToFile e) {
        if (e.getEntityPlayer().hasCapability(CapabilityHeartHandler.CAPABILITY, null)) {
            IHeartHandler cap = (IHeartHandler)e.getEntityPlayer().getCapability(CapabilityHeartHandler.CAPABILITY, null);
            File f = e.getEntityPlayer().func_70005_c_().equals(e.getEntityPlayer().func_184102_h().func_71214_G()) ? new File(e.getEntityPlayer().field_70170_p.func_72860_G().func_75765_b(), "glasshearts_sp.dat") : e.getPlayerFile("glasshearts.dat");
            NBTBase nbt = CapabilityHeartHandler.CAPABILITY.writeNBT((Object)cap, null);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("Hearts", nbt);
            try {
                CompressedStreamTools.func_74793_a((NBTTagCompound)tag, (File)f);
            }
            catch (IOException ex) {
                LOG.error("Error while saving player heart data for {}", new Object[]{e.getEntityPlayer().func_70005_c_(), ex});
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoad(PlayerEvent.LoadFromFile e) {
        File f;
        if (e.getEntityPlayer().func_70005_c_().equals(e.getEntityPlayer().func_184102_h().func_71214_G())) {
            f = new File(e.getEntityPlayer().field_70170_p.func_72860_G().func_75765_b(), "glasshearts_sp.dat");
            if (!f.exists() && e.getPlayerFile("glasshearts.dat").exists()) {
                f = e.getPlayerFile("glasshearts.dat");
            }
        } else {
            f = e.getPlayerFile("glasshearts.dat");
        }
        if (f.exists() && e.getEntityPlayer().hasCapability(CapabilityHeartHandler.CAPABILITY, null)) {
            IHeartHandler cap = (IHeartHandler)e.getEntityPlayer().getCapability(CapabilityHeartHandler.CAPABILITY, null);
            try {
                NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)f);
                NBTBase nbt = tag.func_74781_a("Hearts");
                CapabilityHeartHandler.CAPABILITY.readNBT((Object)cap, null, nbt);
            }
            catch (IOException ex) {
                LOG.error("Error while loading player heart data for {}", new Object[]{e.getEntityPlayer().func_70005_c_(), ex});
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttachCapabilities(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getObject();
            final EntityHeartHandler bhh = new EntityHeartHandler((EntityLivingBase)player);
            e.addCapability(new ResourceLocation("glasshearts", "health"), new ICapabilityProvider(){

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return facing == null && capability == CapabilityHeartHandler.CAPABILITY;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityHeartHandler.CAPABILITY && facing == null) {
                        return (T)bhh;
                    }
                    return null;
                }
            });
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        for (EntityPlayer ep : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            PlayerHandler ph = this.playerHandlers.get(ep);
            if (ph == null) {
                ph = new PlayerHandler(ep);
                this.playerHandlers.put(ep, ph);
            }
            if (e.phase == TickEvent.Phase.START) {
                ph.preTick();
                continue;
            }
            ph.postTick();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        if (e.side != Side.SERVER) {
            return;
        }
        if (e.phase == TickEvent.Phase.START) {
            GlassHeartWorldData data = GlassHeartWorldData.getDataFor(e.world);
            HashSet remove = Collections.emptySet();
            for (GlassHeartData ghd : data.all()) {
                if (e.world.func_175667_e(ghd.getHeartPos())) {
                    TileEntity te = e.world.func_175625_s(ghd.getHeartPos());
                    if (!(te instanceof TileEntityGlassHeart)) {
                        LOG.warn("Deleting orphaned Glass Heart at {}, {}, {}", new Object[]{ghd.getHeartPos().func_177958_n(), ghd.getHeartPos().func_177956_o(), ghd.getHeartPos().func_177952_p()});
                        if (remove.isEmpty()) {
                            remove = Sets.newHashSet();
                        }
                        remove.add(ghd.getHeartPos());
                        continue;
                    }
                    this.update((TileEntityGlassHeart)te, e.world.func_82737_E());
                    continue;
                }
                this.update(ghd, e.world.func_82737_E());
            }
            for (BlockPos pos : remove) {
                data.remove(pos);
            }
        }
    }

    public void update(IGlassHeart igh, long ticks) {
        if (igh.getGem() != Gems.NONE && igh.getGem().getState(igh) != EnumGemState.INACTIVE) {
            Gem originalGem = igh.getGem();
            igh.getGem().update(igh, ticks);
            if (igh.getLifeforce() == 0 && igh.hasBeenFull()) {
                igh.getGem().onEmpty(igh);
            }
            if (igh.getGem() == Gems.NONE) {
                if (igh.getHeartWorld() instanceof WorldServer && igh.getGemStack() != null) {
                    ((WorldServer)igh.getHeartWorld()).func_175739_a(EnumParticleTypes.ITEM_CRACK, (double)igh.getHeartPos().func_177958_n() + 0.5, (double)igh.getHeartPos().func_177956_o() + 0.5, (double)igh.getHeartPos().func_177952_p() + 0.5, 32, 0.0, 0.0, 0.0, 0.2, new int[]{Item.func_150891_b((Item)igh.getGemStack().func_77973_b()), igh.getGemStack().func_77960_j()});
                    igh.getHeartWorld().func_184133_a(null, igh.getHeartPos(), SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 2.0f);
                }
                for (EntityPlayer ep : GlassHearts.getAllOnlineAttunedPlayers(igh)) {
                    IHeartHandler ihh = (IHeartHandler)ep.getCapability(CapabilityHeartHandler.CAPABILITY, null);
                    for (int i = 0; i < ihh.getContainers(); ++i) {
                        BlockHeartContainerOwner bhco;
                        HeartContainer hc = ihh.getContainer(i);
                        HeartContainerOwner owner = hc.getOwner();
                        if (owner == null || !(owner instanceof BlockHeartContainerOwner) || !Objects.equal((Object)(bhco = (BlockHeartContainerOwner)owner).getPos(), (Object)igh.getHeartPos())) continue;
                        hc = hc.copy();
                        hc.setGem(Gems.NONE);
                        ihh.setContainer(i, hc);
                        new PlayHeartEffectMessage(1, Gem.getIdForGem(originalGem), i).sendTo(ep);
                    }
                }
            }
        }
        if (igh.getHeartWorld() == null || !igh.getHeartWorld().field_72995_K) {
            if (igh.getLifeforce() == 0) {
                igh.setHasBeenFull(false);
            }
            if (igh.getLifeforce() == igh.getLifeforceCapacity()) {
                igh.setHasBeenFull(true);
            }
        }
        if (igh.getLifeforceBuffer() > 0 && igh.getLifeforce() < igh.getLifeforceCapacity()) {
            int rate = igh.getGem().adjustFillRate(this.configGlassHeartFillRate);
            int amt = Math.min(rate, Math.min(igh.getLifeforceBuffer(), igh.getLifeforceCapacity() - igh.getLifeforce()));
            igh.setLifeforceBuffer(igh.getLifeforceBuffer() - amt);
            igh.setLifeforce(igh.getLifeforce() + amt);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof EntityCreeper && this.configCreepersSeekHearts) {
            EntityCreeper creeper = (EntityCreeper)e.getEntity();
            creeper.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICreeperSeekHeart(creeper, 1.0));
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent e) {
        DamageSource src;
        if (!e.getEntityLiving().field_70170_p.field_72995_K && (src = e.getSource()).func_76346_g() instanceof EntityPlayer) {
            int amt;
            EntityPlayer p = (EntityPlayer)src.func_76346_g();
            ItemStack held = p.func_184614_ca();
            if (this.configLifeforceFromPlayerKillsOnly && !(e.getEntityLiving() instanceof EntityPlayer)) {
                return;
            }
            if (!this.configLifeforceFromUndead && e.getEntityLiving().func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                return;
            }
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)this.SAPPING, (ItemStack)held);
            if (lvl > 0 && p.field_70170_p.field_73012_v.nextInt(10) < lvl && (amt = p.field_71071_by.func_174925_a(Items.field_151069_bo, 0, 1, null)) == 1) {
                p.func_71064_a(this.LIFEFORCE_COLLECTED, this.configLifeforceBottleSize);
                if (!p.field_71071_by.func_70441_a(new ItemStack((Item)this.LIFEFORCE_BOTTLE))) {
                    p.func_145779_a((Item)this.LIFEFORCE_BOTTLE, 1);
                }
                p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, this.SAP, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                EntityLivingBase el = e.getEntityLiving();
                new ParticleEffectMessage(el.field_70165_t, el.field_70163_u, el.field_70161_v, (Entity)p, 0).sendToAllWatching((Entity)el);
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem e) {
        BlockPos pos;
        RayTraceResult rtr;
        World world = e.getWorld();
        EntityPlayer player = e.getEntityPlayer();
        ItemStack stack = e.getItemStack();
        if (stack != null && stack.func_77973_b() instanceof ItemGlassBottle && (rtr = (RayTraceResult)this.rayTrace.invoke(e.getItemStack().func_77973_b(), world, player, true)) != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175660_a(player, pos = rtr.func_178782_a()) && player.func_175151_a(pos.func_177972_a(rtr.field_178784_b), rtr.field_178784_b, stack) && world.func_180495_p(pos).func_177230_c() == this.LIFEFORCE_BLOCK) {
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 0.75f, 1.0f);
            world.func_175698_g(pos);
            e.setResult(Event.Result.DENY);
            if (!player.func_184812_l_()) {
                --e.getItemStack().field_77994_a;
                ItemStack res = new ItemStack((Item)this.LIFEFORCE_BOTTLE);
                if (!player.field_71071_by.func_70441_a(res)) {
                    player.func_71019_a(res, false);
                }
            }
        }
    }

    public static List<EntityPlayer> getAllOnlineAttunedPlayers(IGlassHeart igh) {
        List players;
        if (igh.getHeartWorld() != null) {
            players = igh.getHeartWorld().func_73046_m() != null ? igh.getHeartWorld().func_73046_m().func_184103_al().func_181057_v() : igh.getHeartWorld().field_73010_i;
        } else {
            return Collections.emptyList();
        }
        ArrayList li = Lists.newArrayList();
        block0: for (EntityPlayer ep : players) {
            if (!ep.hasCapability(CapabilityHeartHandler.CAPABILITY, null)) continue;
            IHeartHandler ihh = (IHeartHandler)ep.getCapability(CapabilityHeartHandler.CAPABILITY, null);
            for (HeartContainer hc : ihh) {
                BlockHeartContainerOwner bhco;
                HeartContainerOwner owner = hc.getOwner();
                if (!(owner instanceof BlockHeartContainerOwner) || !Objects.equal((Object)(bhco = (BlockHeartContainerOwner)owner).getPos(), (Object)igh.getHeartPos())) continue;
                li.add(ep);
                continue block0;
            }
        }
        return li;
    }

    public static void sendUpdatePacket(TileEntity te) {
        GlassHearts.sendUpdatePacket(te, te.func_189517_E_());
    }

    public static void sendUpdatePacket(TileEntity te, NBTTagCompound nbt) {
        if (!te.func_145830_o() || te.func_145831_w().field_72995_K) {
            return;
        }
        WorldServer ws = (WorldServer)te.func_145831_w();
        Chunk c = te.func_145831_w().func_175726_f(te.func_174877_v());
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(te.func_174877_v(), te.func_145832_p(), nbt);
        for (EntityPlayerMP player : te.func_145831_w().func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
            if (!ws.func_184164_w().func_72694_a(player, c.field_76635_g, c.field_76647_h)) continue;
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }

    private static /* synthetic */ String lambda$new$0(int mb) {
        if (mb > 1000) {
            return mb / 1000 + "." + mb / 100 % 10 + "B";
        }
        return mb + "mB";
    }

    static {
        LOG = LogManager.getLogger((String)"GlassHearts");
        FluidRegistry.enableUniversalBucket();
    }

    static /* synthetic */ String access$lambda$0(int n) {
        return GlassHearts.lambda$new$0(n);
    }
}

