/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.block;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.capability.CapabilityHeartHandler;
import com.elytradev.glasshearts.capability.IHeartHandler;
import com.elytradev.glasshearts.enums.EnumGemState;
import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.logic.BlockHeartContainerOwner;
import com.elytradev.glasshearts.logic.HeartContainer;
import com.elytradev.glasshearts.logic.HeartContainerOwner;
import com.elytradev.glasshearts.network.ParticleEffectMessage;
import com.elytradev.glasshearts.network.PlayHeartEffectMessage;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart;
import com.elytradev.glasshearts.world.GlassHeartWorldData;
import com.google.common.base.Objects;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;

public class BlockGlassHeart
extends Block {
    public static final PropertyBool INNER = PropertyBool.func_177716_a((String)"inner");
    public static final PropertyBool STAINED = PropertyBool.func_177716_a((String)"stained");

    public BlockGlassHeart() {
        super(Material.field_151592_s);
        this.func_149711_c(0.5f);
        this.func_149752_b(0.3f);
        this.func_149672_a(new SoundType(1.0f, 1.0f, SoundEvents.field_187565_bO, SoundEvents.field_187569_bQ, SoundEvents.field_187567_bP, SoundEvents.field_187565_bO, SoundEvents.field_187563_bN));
        this.func_149713_g(0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INNER, STAINED});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGlassHeart) {
            TileEntityGlassHeart tegh = (TileEntityGlassHeart)te;
            return (int)((float)(tegh.getLifeforce() + tegh.getLifeforceBuffer()) / (float)tegh.getLifeforceCapacity() * 15.0f);
        }
        return super.func_180641_l(blockState, worldIn, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack stack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGlassHeart) {
            TileEntityGlassHeart tegh = (TileEntityGlassHeart)te;
            if (stack == null && tegh.getGem() != Gems.NONE) {
                if (tegh.getGem().getState(tegh) == EnumGemState.ACTIVE_CURSED) {
                    return false;
                }
                if (!worldIn.field_72995_K) {
                    if (tegh.getGemStack() != null) {
                        BlockGlassHeart.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)tegh.getGemStack());
                    }
                    tegh.setGemStack(null);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187716_o, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            if (stack != null && Gem.fromItemStack(stack) != Gems.NONE) {
                if (tegh.getGem().getState(tegh) == EnumGemState.ACTIVE_CURSED) {
                    return false;
                }
                if (!worldIn.field_72995_K) {
                    if (tegh.getGemStack() != null) {
                        BlockGlassHeart.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)tegh.getGemStack());
                    }
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187716_o, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    tegh.setGemStack(stack.func_77979_a(1));
                }
                return true;
            }
            if (stack != null && stack.func_77973_b() == GlassHearts.inst.STAFF) {
                if (worldIn.field_72995_K) {
                    return true;
                }
                if (playerIn.hasCapability(CapabilityHeartHandler.CAPABILITY, null)) {
                    IHeartHandler cap = (IHeartHandler)playerIn.getCapability(CapabilityHeartHandler.CAPABILITY, null);
                    for (int i = 0; i < cap.getContainers(); ++i) {
                        BlockHeartContainerOwner bhco;
                        HeartContainer hc = cap.getContainer(i);
                        HeartContainerOwner owner = hc.getOwner();
                        if (!(owner instanceof BlockHeartContainerOwner) || !Objects.equal((Object)(bhco = (BlockHeartContainerOwner)owner).getPos(), (Object)pos)) continue;
                        if (tegh.getGem().getState(tegh) == EnumGemState.ACTIVE_CURSED) {
                            return false;
                        }
                        cap.removeContainer(i);
                        new PlayHeartEffectMessage(3, tegh.getColor().ordinal(), i).sendTo(playerIn);
                        return true;
                    }
                    if (cap.getContainers() < GlassHearts.inst.configMaxContainers) {
                        cap.addContainer(HeartContainer.createGlass(tegh));
                        stack.func_77972_a(1, (EntityLivingBase)playerIn);
                        worldIn.func_184133_a(null, pos, GlassHearts.inst.ATTUNE, SoundCategory.PLAYERS, 1.0f, 2.0f);
                        ParticleEffectMessage p = new ParticleEffectMessage((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (Entity)playerIn, 1);
                        p.sendToAllWatching((Entity)playerIn);
                        p.sendTo(playerIn);
                    } else {
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("msg.glasshearts.limitReached", new Object[0]));
                    }
                    return true;
                }
                return false;
            }
            if (stack != null && stack.func_77973_b() != GlassHearts.inst.LIFEFORCE_BOTTLE && tegh.getLifeforceBuffer() < tegh.getLifeforceCapacity()) {
                try {
                    IFluidHandler ifhi;
                    FluidStack rtrn;
                    if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (rtrn = (ifhi = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(new FluidStack(GlassHearts.inst.LIFEFORCE, tegh.getLifeforceCapacity() - tegh.getLifeforce() - tegh.getLifeforceBuffer()), !worldIn.field_72995_K)) != null) {
                        if (rtrn.getFluid() == GlassHearts.inst.LIFEFORCE) {
                            if (stack.func_77973_b() == GlassHearts.inst.LIFEFORCE_BOTTLE) {
                                --stack.field_77994_a;
                                if (!playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo))) {
                                    playerIn.func_71019_a(new ItemStack(Items.field_151069_bo), false);
                                }
                            }
                            tegh.setLifeforceBuffer(tegh.getLifeforceBuffer() + rtrn.amount);
                            worldIn.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            return true;
                        }
                        LogManager.getLogger((String)"GlassHearts").warn("We asked '{}' for '{}', but it gave us '{}' instead!", new Object[]{stack.func_77973_b().getRegistryName(), GlassHearts.inst.LIFEFORCE.getUnlocalizedName(), rtrn.getFluid().getUnlocalizedName()});
                    }
                }
                catch (Throwable t) {
                    LogManager.getLogger((String)"GlassHearts").warn("It seems the mod that owns the item '{}' doesn't know null-side caps are valid! This is a bug!", new Object[]{stack.func_77973_b().getRegistryName(), t});
                }
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, stack, facing, hitX, hitY, hitZ);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (!world.field_72995_K && te instanceof TileEntityGlassHeart) {
                TileEntityGlassHeart tegh = (TileEntityGlassHeart)te;
                if (tegh.getLifeforce() + tegh.getLifeforceBuffer() > 1000) {
                    world.func_175713_t(pos);
                    world.func_175656_a(pos, GlassHearts.inst.LIFEFORCE_BLOCK.func_176223_P());
                } else {
                    world.func_175713_t(pos);
                    world.func_175698_g(pos);
                }
            }
            GlassHeartWorldData.getDataFor(world).remove(pos);
        }
        this.func_180652_a(world, pos, explosion);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityGlassHeart tegh;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGlassHeart && (tegh = (TileEntityGlassHeart)te).getGem().getState(tegh) == EnumGemState.ACTIVE_CURSED) {
            return -1.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity te = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && te instanceof TileEntityGlassHeart) {
            TileEntityGlassHeart tegh = (TileEntityGlassHeart)te;
            if (stack.func_77973_b() == Item.func_150898_a((Block)GlassHearts.inst.GLASS_HEART)) {
                int meta = stack.func_77960_j();
                EnumGlassColor egc = EnumGlassColor.values()[meta % EnumGlassColor.values().length];
                tegh.setColor(egc);
                if (stack.func_82837_s()) {
                    tegh.setName(stack.func_82833_r());
                }
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        boolean placeLiquid = false;
        TileEntity te = worldIn.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if (!worldIn.field_72995_K && te instanceof TileEntityGlassHeart) {
            TileEntityGlassHeart tegh = (TileEntityGlassHeart)te;
            BlockGlassHeart.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getPickBlock(worldIn.func_180495_p(pos), null, worldIn, pos, null));
            if (tegh.getGemStack() != null) {
                BlockGlassHeart.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)tegh.getGemStack());
            }
            if (tegh.getLifeforce() + tegh.getLifeforceBuffer() > 1000) {
                placeLiquid = true;
            }
            if (tegh.getColor() == EnumGlassColor.NONE) {
                worldIn.func_175718_b(2001, pos, Block.func_149682_b((Block)Blocks.field_150359_w));
            } else {
                worldIn.func_175718_b(2001, pos, tegh.getColor().ordinal() - 1 << 12 | Block.func_149682_b((Block)Blocks.field_150399_cn));
            }
            GlassHeartWorldData.getDataFor(worldIn).remove(pos);
        }
        super.func_180663_b(worldIn, pos, state);
        if (placeLiquid) {
            worldIn.func_175656_a(pos, GlassHearts.inst.LIFEFORCE_BLOCK.func_176223_P());
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlassHeart) {
            TileEntityGlassHeart tegh = (TileEntityGlassHeart)te;
            ItemStack stack = new ItemStack((Block)GlassHearts.inst.GLASS_HEART, 1, tegh.getColor().ordinal());
            if (tegh.getName() != null) {
                stack.func_151001_c(tegh.getName());
            }
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGlassHeart();
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 17; ++i) {
            list.add(new ItemStack(itemIn, 1, i));
        }
    }
}

