/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.client;

import com.elytradev.glasshearts.CommonProxy;
import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.client.HeartRenderer;
import com.elytradev.glasshearts.client.RenderGlassHeart;
import com.elytradev.glasshearts.client.guiparticle.GuiParticle;
import com.elytradev.glasshearts.enums.EnumGemOre;
import com.elytradev.glasshearts.enums.EnumGemState;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.init.Gems;
import com.elytradev.glasshearts.tile.TileEntityGlassHeart;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientProxy
extends CommonProxy {
    public HeartRenderer heartRenderer = new HeartRenderer();
    private List<TileEntityGlassHeart> glassHearts = Lists.newArrayList();
    public List<GuiParticle> guiParticles = Lists.newArrayList();

    @Override
    public void onPreInit() {
        super.onPreInit();
        ModelLoader.setCustomModelResourceLocation((Item)GlassHearts.inst.LIFEFORCE_BOTTLE, (int)0, (ModelResourceLocation)new ModelResourceLocation("glasshearts:lifeforce_bottle#inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)GlassHearts.inst.STAFF, (int)0, (ModelResourceLocation)new ModelResourceLocation("glasshearts:staff#inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GlassHearts.inst.GLASS_HEART), (int)0, (ModelResourceLocation)new ModelResourceLocation("glasshearts:glass_heart#inventory"));
        for (int i = 1; i < 17; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GlassHearts.inst.GLASS_HEART), (int)i, (ModelResourceLocation)new ModelResourceLocation("glasshearts:stained_glass_heart#inventory"));
        }
        for (EnumGemOre gem : EnumGemOre.VALUES) {
            ModelLoader.setCustomModelResourceLocation((Item)GlassHearts.inst.GEM, (int)gem.ordinal(), (ModelResourceLocation)new ModelResourceLocation("glasshearts:" + gem.func_176610_l() + "#inventory"));
            if (gem == EnumGemOre.AMBER) continue;
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GlassHearts.inst.ORE), (int)gem.ordinalWithoutAmber(), (ModelResourceLocation)new ModelResourceLocation("glasshearts:ore#variant=" + gem.func_176610_l()));
        }
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GlassHearts.inst.PETRIFIED_LOG), (int)0, (ModelResourceLocation)new ModelResourceLocation("glasshearts:petrified_log#axis=y"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGlassHeart.class, (TileEntitySpecialRenderer)new RenderGlassHeart());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        Minecraft.func_71410_x().getItemColors().func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (stack.func_77960_j() == 0) {
                    return -1;
                }
                float[] fleece = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)(stack.func_77960_j() - 1)));
                int color = ((int)(fleece[0] * 255.0f) & 0xFF) << 16 | ((int)(fleece[1] * 255.0f) & 0xFF) << 8 | (int)(fleece[2] * 255.0f) & 0xFF;
                return color;
            }
        }, new Block[]{GlassHearts.inst.GLASS_HEART});
    }

    @SubscribeEvent
    public void onPreRender(RenderGameOverlayEvent.Pre e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.HEALTH && GlassHearts.inst.configOverrideHealthRenderer && !this.heartRenderer.containers.isEmpty()) {
            e.setCanceled(true);
            this.heartRenderer.renderHealth(e.getResolution(), e.getPartialTicks());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        }
    }

    @SubscribeEvent
    public void onPostRender(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a("glasshearts:guiparticlesrender");
            for (GuiParticle gp : this.guiParticles) {
                if (gp.posY > (double)(e.getResolution().func_78328_b() + 24) || gp.posX > (double)(e.getResolution().func_78326_a() + 24) || gp.posX < -24.0) {
                    gp.setExpired();
                }
                gp.render(e.getPartialTicks());
            }
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    @Override
    public void onLoad(TileEntityGlassHeart te) {
        super.onLoad(te);
        if (te.func_145830_o() && te.func_145831_w().field_72995_K) {
            te.setClient(true);
            this.glassHearts.add(te);
        }
    }

    @SubscribeEvent
    public void onText(RenderGameOverlayEvent.Text e) {
        for (int i = 0; i < e.getLeft().size(); ++i) {
            if (!((String)e.getLeft().get(i)).startsWith("P:")) continue;
            e.getLeft().set(i, (String)e.getLeft().get(i) + ", GuiP: " + this.guiParticles.size());
            break;
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent e) {
        Gem gem = Gem.fromItemStack(e.getItemStack());
        if (gem != Gems.NONE) {
            String s;
            String swp = null;
            if (e.isShowAdvancedItemTooltips()) {
                swp = (String)e.getToolTip().remove(e.getToolTip().size() - 1);
            }
            if (I18n.func_188566_a((String)("tooltip.glasshearts.when_heart_adorned." + gem.getRegistryName().func_110623_a()))) {
                e.getToolTip().add("\u00a75" + I18n.func_135052_a((String)"tooltip.glasshearts.when_heart_adorned", (Object[])new Object[0]));
                s = I18n.func_135052_a((String)("tooltip.glasshearts.when_heart_adorned." + gem.getRegistryName().func_110623_a()), (Object[])new Object[0]);
                for (String l : Splitter.on((String)"\\n").split((CharSequence)s)) {
                    e.getToolTip().add("  \u00a79" + l);
                }
            }
            if (I18n.func_188566_a((String)("tooltip.glasshearts.when_heart_emptied." + gem.getRegistryName().func_110623_a()))) {
                e.getToolTip().add("\u00a75" + I18n.func_135052_a((String)"tooltip.glasshearts.when_heart_emptied", (Object[])new Object[0]));
                s = I18n.func_135052_a((String)("tooltip.glasshearts.when_heart_emptied." + gem.getRegistryName().func_110623_a()), (Object[])new Object[0]);
                for (String l : Splitter.on((String)"\\n").split((CharSequence)s)) {
                    e.getToolTip().add("  \u00a79" + l);
                }
            }
            if (e.isShowAdvancedItemTooltips() && swp != null) {
                e.getToolTip().add(swp);
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            if (!Minecraft.func_71410_x().func_147113_T()) {
                Minecraft.func_71410_x().field_71424_I.func_76320_a("glasshearts:guiparticlesupdate");
                Iterator<GuiParticle> iter = this.guiParticles.iterator();
                while (iter.hasNext()) {
                    GuiParticle gp = iter.next();
                    gp.update();
                    if (!gp.expired) continue;
                    iter.remove();
                }
                Minecraft.func_71410_x().field_71424_I.func_76319_b();
            }
            if (Minecraft.func_71410_x().field_71441_e != null) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                this.heartRenderer.tick();
                Iterator<TileEntityGlassHeart> iter = this.glassHearts.iterator();
                while (iter.hasNext()) {
                    TileEntityGlassHeart tegh = iter.next();
                    if (tegh.func_145837_r()) {
                        iter.remove();
                        continue;
                    }
                    GlassHearts.inst.update(tegh, tegh.func_145831_w().func_82737_E());
                    if (Minecraft.func_71410_x().func_147113_T() || !(tegh.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 384.0) || tegh.getGem() == Gems.NONE || tegh.getGem().getState(tegh) == EnumGemState.INACTIVE) continue;
                    float yaw = (float)Math.toRadians(RenderGlassHeart.getAnimTime(tegh, 0.0f) % 360.0f);
                    Vec3d base = new Vec3d((Vec3i)tegh.getHeartPos()).func_72441_c(0.5, 0.565, 0.5);
                    float dist = 0.3f;
                    Vec3d dir = new Vec3d((double)MathHelper.func_76126_a((float)yaw), 0.0, (double)MathHelper.func_76134_b((float)yaw)).func_186678_a((double)dist);
                    Vec3d aPos = base.func_178787_e(dir);
                    Vec3d bPos = base.func_178788_d(dir);
                    ParticleRedstone a = new ParticleRedstone((World)Minecraft.func_71410_x().field_71441_e, aPos.field_72450_a, aPos.field_72448_b, aPos.field_72449_c, 1.0f, 1.0f, 1.0f, 1.0f){};
                    ParticleRedstone b = new ParticleRedstone((World)Minecraft.func_71410_x().field_71441_e, bPos.field_72450_a, bPos.field_72448_b, bPos.field_72449_c, 1.0f, 1.0f, 1.0f, 1.0f){};
                    int gemColor = tegh.getGem().getColor();
                    float c1 = (player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f;
                    float c2 = (player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f;
                    a.func_70538_b((float)(gemColor >> 16 & 0xFF) / 255.0f + c1, (float)(gemColor >> 8 & 0xFF) / 255.0f + c1, (float)(gemColor & 0xFF) / 255.0f + c1);
                    b.func_70538_b((float)(gemColor >> 16 & 0xFF) / 255.0f + c2, (float)(gemColor >> 8 & 0xFF) / 255.0f + c2, (float)(gemColor & 0xFF) / 255.0f + c2);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)a);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)b);
                }
            } else {
                this.glassHearts.clear();
            }
        }
    }
}

