/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.client.guiparticle;

import com.elytradev.glasshearts.client.HeartRenderer;
import com.elytradev.glasshearts.client.guiparticle.GuiParticle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiParticleHeartFragment
extends GuiParticle {
    private ResourceLocation texture;
    private float u;
    private float v;
    private float w;
    private float h;
    private int textureWidth;
    private int textureHeight;
    private boolean fade;

    public GuiParticleHeartFragment(ResourceLocation texture, double x, double y, float u, float v, float w, float h, int textureWidth, int textureHeight, boolean fade) {
        super(x, y);
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.fade = fade;
        if (fade) {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.maxAge = 10;
            this.gravity = 0.0f;
        } else {
            this.motionX = this.rand.nextGaussian() * 0.6;
            this.motionY = -1.0;
            this.maxAge = Integer.MAX_VALUE;
        }
    }

    @Override
    public void render(float partialTicks) {
        float interpPosX = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks);
        float interpPosY = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        float alpha = 1.0f;
        if (this.fade) {
            alpha = 1.0f - MathHelper.func_76126_a((float)((float)this.age / (float)this.maxAge * 1.5707964f));
        }
        GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)alpha);
        HeartRenderer.drawModalRectWithCustomSizedTexture(interpPosX, interpPosY, this.u, this.v, this.w, this.h, this.textureWidth, this.textureHeight);
    }

    public static void spawnShatter(List<GuiParticle> guiParticles, ResourceLocation texture, int x, int y, float u, float v, float width, float height, int textureWidth, int textureHeight, float particleWidth, float particleHeight, float r, float g, float b) {
        float divW = width / particleWidth;
        float divH = height / particleHeight;
        int i = 0;
        while ((float)i < divW * divH) {
            GuiParticleHeartFragment p = new GuiParticleHeartFragment(texture, (float)x + (float)i % divW * particleWidth, (float)y + (float)i / divW * particleHeight, u + (float)i % divW * particleWidth, v + (float)i / divW * particleHeight, particleWidth, particleHeight, textureWidth, textureHeight, false);
            p.red = r;
            p.green = g;
            p.blue = b;
            guiParticles.add(p);
            ++i;
        }
    }

    public static void spawnFade(List<GuiParticle> guiParticles, ResourceLocation texture, int x, int y, float u, float v, float width, float height, int textureWidth, int textureHeight, float r, float g, float b) {
        GuiParticleHeartFragment p = new GuiParticleHeartFragment(texture, x, y, u, v, width, height, textureWidth, textureHeight, true);
        p.red = r;
        p.green = g;
        p.blue = b;
        guiParticles.add(p);
    }
}

