/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.integration.tcon;

import com.elytradev.glasshearts.GlassHearts;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.tools.modifiers.ToolModifier;

public class ModifierSapping
extends ToolModifier {
    public ModifierSapping() {
        super("glasshearts.tcon.sapping", 0xFF1313);
        this.addAspects(new ModifierAspect[]{ModifierAspect.weaponOnly});
        this.addAspects(new ModifierAspect[]{new ModifierAspect.MultiAspect((IModifier)this, 10, 3, 1)});
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        for (int i = 0; i < data.level; ++i) {
            ToolBuilder.addEnchantment((NBTTagCompound)rootCompound, (Enchantment)GlassHearts.inst.SAPPING);
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        return ImmutableList.of((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{Util.dfPercent.format((float)EnchantmentHelper.func_77506_a((Enchantment)GlassHearts.inst.SAPPING, (ItemStack)tool) / 10.0f)}));
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        int level = data.level;
        String tooltip = this.getLocalizedName();
        if (level > 0) {
            tooltip = tooltip + " " + TinkerUtil.getRomanNumeral((int)level);
        }
        if (detailed) {
            tooltip = tooltip + " " + data.extraInfo;
        }
        return tooltip;
    }
}

