/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.network;

import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.logic.HeartContainer;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.Marshaller;
import io.netty.buffer.ByteBuf;

public class HeartContainerMarshaller
implements Marshaller<HeartContainer> {
    public static final String NAME = "com.elytradev.glasshearts.network.HeartContainerMarshaller";
    public static final HeartContainerMarshaller INSTANCE = new HeartContainerMarshaller();

    @Override
    public HeartContainer unmarshal(ByteBuf in) {
        short id = in.readUnsignedByte();
        if (id == 0) {
            return null;
        }
        Gem gem = Gem.getGemById(id - 1);
        short colorId = in.readUnsignedByte();
        EnumGlassColor color = colorId == 0 ? null : EnumGlassColor.values()[colorId - 1];
        float fill = (float)in.readUnsignedByte() / 255.0f;
        HeartContainer hc = new HeartContainer(color, gem, fill, null);
        return hc;
    }

    @Override
    public void marshal(ByteBuf out, HeartContainer t) {
        if (t == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(Gem.getIdForGem(t.getGem()) + 1);
        out.writeByte(t.getGlassColor() == null ? 0 : t.getGlassColor().ordinal() + 1);
        out.writeByte(t.getFillAmountInt());
    }
}

