/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.network;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.client.ClientProxy;
import com.elytradev.glasshearts.client.HeartRenderer;
import com.elytradev.glasshearts.client.guiparticle.GuiParticleHeartFragment;
import com.elytradev.glasshearts.client.guiparticle.GuiParticleSmoke;
import com.elytradev.glasshearts.client.guiparticle.PendingEffect;
import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.gem.Gem;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.Message;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.NetworkContext;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.annotation.field.MarshalledAs;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.annotation.type.ReceivedOn;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ReceivedOn(value=Side.CLIENT)
public class PlayHeartEffectMessage
extends Message {
    public static final int EFFECT_HEART_SHATTER = 0;
    public static final int EFFECT_GEM_SHATTER = 1;
    public static final int EFFECT_WASTED_HEALING = 2;
    public static final int EFFECT_UNATTUNE = 3;
    @MarshalledAs(value="u8")
    private int effect;
    @MarshalledAs(value="u8")
    private int meta;
    @MarshalledAs(value="u8")
    private int index;

    public PlayHeartEffectMessage(NetworkContext ctx) {
        super(ctx);
    }

    public PlayHeartEffectMessage(int effect, int meta, int index) {
        super(GlassHearts.inst.NETWORK);
        this.effect = effect;
        this.meta = meta;
        this.index = index;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityPlayer sender) {
        final Minecraft mc = Minecraft.func_71410_x();
        final ClientProxy cp = (ClientProxy)GlassHearts.proxy;
        if (this.effect == 0) {
            if (this.meta == 0) {
                cp.heartRenderer.pendingEffects.add(new PendingEffect(this.index, new PendingEffect.EffectSpawner(){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void spawn(int x, int y) {
                        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187561_bM, (float)1.0f));
                        GuiParticleHeartFragment.spawnShatter(cp.guiParticles, HeartRenderer.TEX, x, y, 27.0f, 36.0f, 9.0f, 9.0f, 256, 256, 3.0f, 3.0f, 1.0f, 1.0f, 1.0f);
                    }
                }));
            } else {
                EnumGlassColor egc = EnumGlassColor.values()[this.meta];
                final float[] fleece = EntitySheep.func_175513_a((EnumDyeColor)egc.dye);
                cp.heartRenderer.pendingEffects.add(new PendingEffect(this.index, new PendingEffect.EffectSpawner(){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void spawn(int x, int y) {
                        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187561_bM, (float)1.0f));
                        GuiParticleHeartFragment.spawnShatter(cp.guiParticles, HeartRenderer.TEX, x, y, 45.0f, 36.0f, 9.0f, 9.0f, 256, 256, 3.0f, 3.0f, fleece[0], fleece[1], fleece[2]);
                    }
                }));
            }
        } else if (this.effect == 1) {
            final Gem gem = Gem.getGemById(this.meta);
            cp.heartRenderer.pendingEffects.add(new PendingEffect(this.index, new PendingEffect.EffectSpawner(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void spawn(int x, int y) {
                    mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187561_bM, (float)2.0f));
                    GuiParticleHeartFragment.spawnShatter(cp.guiParticles, gem.getTexture(), x, y, gem.getU(), gem.getV(), gem.getWidth(), gem.getHeight(), gem.getTextureWidth(), gem.getTextureHeight(), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }));
        } else if (this.effect == 2) {
            cp.heartRenderer.pendingEffects.add(new PendingEffect(this.index, new PendingEffect.EffectSpawner(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void spawn(int x, int y) {
                    mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187646_bt, (float)2.0f));
                    for (int i = 0; i < PlayHeartEffectMessage.this.meta + 1; ++i) {
                        GuiParticleSmoke s = new GuiParticleSmoke(x + 5, y);
                        s.motionX += 0.75;
                        s.motionY = s.rand.nextFloat() * 2.0f - 1.0f;
                        s.red = 0.8f + s.rand.nextFloat() * 0.2f;
                        s.green = 0.0f;
                        s.blue = 0.0f;
                        cp.guiParticles.add(s);
                    }
                }
            }));
        } else if (this.effect == 3) {
            if (this.meta == 0) {
                cp.heartRenderer.pendingEffects.add(new PendingEffect(this.index, new PendingEffect.EffectSpawner(){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void spawn(int x, int y) {
                        GuiParticleHeartFragment.spawnFade(cp.guiParticles, HeartRenderer.TEX, x, y, 27.0f, 36.0f, 9.0f, 9.0f, 256, 256, 1.0f, 1.0f, 1.0f);
                    }
                }));
            } else {
                EnumGlassColor egc = EnumGlassColor.values()[this.meta];
                final float[] fleece = EntitySheep.func_175513_a((EnumDyeColor)egc.dye);
                cp.heartRenderer.pendingEffects.add(new PendingEffect(this.index, new PendingEffect.EffectSpawner(){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void spawn(int x, int y) {
                        GuiParticleHeartFragment.spawnFade(cp.guiParticles, HeartRenderer.TEX, x, y, 45.0f, 36.0f, 9.0f, 9.0f, 256, 256, fleece[0], fleece[1], fleece[2]);
                    }
                }));
            }
        }
    }
}

