/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.network;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.client.ClientProxy;
import com.elytradev.glasshearts.logic.HeartContainer;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.Message;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.NetworkContext;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.annotation.field.MarshalledAs;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.annotation.type.ReceivedOn;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ReceivedOn(value=Side.CLIENT)
public class UpdateHeartsMessage
extends Message {
    @MarshalledAs(value="u8")
    private int startIndex;
    @MarshalledAs(value="com.elytradev.glasshearts.network.HeartContainerListMarshaller")
    private List<HeartContainer> containers;

    public UpdateHeartsMessage(NetworkContext ctx) {
        super(ctx);
    }

    public UpdateHeartsMessage(int startIndex, boolean overwrite, List<HeartContainer> containers) {
        super(GlassHearts.inst.NETWORK);
        this.startIndex = startIndex;
        if (overwrite) {
            this.startIndex |= 0x80;
        }
        this.containers = containers;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityPlayer sender) {
        boolean overwrite = (this.startIndex & 0x80) != 0;
        int startIndex = this.startIndex & 0xFFFFFF7F;
        List<HeartContainer> li = ((ClientProxy)GlassHearts.proxy).heartRenderer.containers;
        if (overwrite) {
            li.clear();
        }
        for (int i = 0; i < this.containers.size(); ++i) {
            if (startIndex + i >= li.size()) {
                if (this.containers.get(i) == null) continue;
                li.add(this.containers.get(i));
                continue;
            }
            HeartContainer old = li.get(startIndex + i);
            HeartContainer nw = this.containers.get(i);
            if (nw == null) {
                li.remove(startIndex + i);
                --startIndex;
                continue;
            }
            if (old != null && old.getGlassColor() == nw.getGlassColor() && old.getGem() == nw.getGem()) {
                old.setLastFillAmount(old.getLastFillAmount());
                old.setFillAmount(nw.getFillAmount());
                continue;
            }
            if (old != null) {
                nw.animationTicks = old.animationTicks;
            }
            li.set(startIndex + i, nw);
        }
    }
}

