/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.world;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.block.BlockPetrifiedLog;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.accessor.Accessor;
import com.elytradev.glasshearts.repackage.io.github.elytra.concrete.accessor.Accessors;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderOverworld;
import net.minecraftforge.common.BiomeDictionary;

public class GeneratePetrifiedTree {
    private static final Accessor<Biome[]> biomesForGeneration = Accessors.findField(ChunkProviderOverworld.class, "field_185981_C", "biomesForGeneration", "D");
    private static Random random = new Random(0L);

    public static void generate(long seed, ChunkPrimer primer, IChunkGenerator gen) {
        block18: {
            if (!(gen instanceof ChunkProviderOverworld)) {
                return;
            }
            random.setSeed(seed);
            int x = 8;
            int z = 8;
            int y = 128;
            Biome[] biomes = biomesForGeneration.get(gen);
            Biome b = biomes[z + x * 16];
            if (b == null || !BiomeDictionary.isBiomeOfType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || random.nextInt(5) != 0) break block18;
            while (true) {
                if (y <= 0) {
                    return;
                }
                IBlockState ibs = primer.func_177856_a(x, y, z);
                if (ibs.func_177230_c() != Blocks.field_150350_a) {
                    ++y;
                    break;
                }
                --y;
            }
            IBlockState brownMush = Blocks.field_150338_P.func_176223_P();
            IBlockState redMush = Blocks.field_150337_Q.func_176223_P();
            BlockLog.EnumAxis axis = BlockLog.EnumAxis.values()[random.nextInt(3)];
            int length = random.nextInt(3) + 4;
            IBlockState ibs = GlassHearts.inst.PETRIFIED_LOG.func_176223_P().func_177226_a((IProperty)BlockPetrifiedLog.field_176299_a, (Comparable)axis);
            switch (axis) {
                case X: {
                    x -= length / 2;
                    for (int i = 0; i < length; ++i) {
                        primer.func_177855_a(x + i, y, z, ibs);
                        if (random.nextInt(3) != 0) continue;
                        primer.func_177855_a(x + i, y + 1, z, random.nextBoolean() ? brownMush : redMush);
                    }
                    break;
                }
                case Z: {
                    z -= length / 2;
                    for (int i = 0; i < length; ++i) {
                        primer.func_177855_a(x, y, z + i, ibs);
                        if (random.nextInt(3) != 0) continue;
                        primer.func_177855_a(x, y + 1, z + i, random.nextBoolean() ? brownMush : redMush);
                    }
                    break;
                }
                case Y: {
                    int up = random.nextInt(3) + 1;
                    length -= up;
                    for (int i = 0; i < up; ++i) {
                        primer.func_177855_a(x, y + i, z, ibs);
                    }
                    BlockLog.EnumAxis axis2 = random.nextBoolean() ? BlockLog.EnumAxis.X : BlockLog.EnumAxis.Z;
                    IBlockState ibs2 = GlassHearts.inst.PETRIFIED_LOG.func_176223_P().func_177226_a((IProperty)BlockPetrifiedLog.field_176299_a, (Comparable)axis2);
                    boolean negative = random.nextBoolean();
                    switch (axis2) {
                        case X: {
                            x = negative ? (x -= length + 1) : (x += 2);
                            for (int i = 0; i < length; ++i) {
                                primer.func_177855_a(x + i, y, z, ibs2);
                                if (random.nextInt(3) != 0) continue;
                                primer.func_177855_a(x + i, y + 1, z, random.nextBoolean() ? brownMush : redMush);
                            }
                            break block18;
                        }
                        case Z: {
                            z = negative ? (z -= length + 1) : (z += 2);
                            for (int i = 0; i < length; ++i) {
                                primer.func_177855_a(x, y, z + i, ibs2);
                                if (random.nextInt(3) != 0) continue;
                                primer.func_177855_a(x, y + 1, z + i, random.nextBoolean() ? brownMush : redMush);
                            }
                        }
                    }
                }
            }
        }
    }
}

