/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.glasshearts.world;

import com.elytradev.glasshearts.GlassHearts;
import com.elytradev.glasshearts.NBTHelper;
import com.elytradev.glasshearts.enums.EnumGlassColor;
import com.elytradev.glasshearts.world.GlassHeartData;
import com.elytradev.glasshearts.world.GlassHeartWorldData$$Lambda$1;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class GlassHeartWorldData
extends WorldSavedData {
    private static final NBTHelper nh = new NBTHelper();
    private World world;
    private Map<BlockPos, GlassHeartData> hearts = Maps.newHashMap();

    public GlassHeartWorldData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (GlassHeartData ghd : nh.deserialize(GlassHeartWorldData$$Lambda$1.lambdaFactory$(this), nbt.func_150295_c("Hearts", 10))) {
            this.hearts.put(ghd.getHeartPos(), ghd);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74782_a("Hearts", (NBTBase)nh.serialize(this.hearts.values()));
        return nbt;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public GlassHeartData create(BlockPos pos, EnumGlassColor color, ItemStack gemStack, int lifeforce, int lifeforceBuffer) {
        GlassHeartData ghd = new GlassHeartData(this, pos, color, gemStack, lifeforce, lifeforceBuffer);
        this.hearts.put(pos, ghd);
        this.func_76185_a();
        return ghd;
    }

    public GlassHeartData get(BlockPos pos) {
        return this.hearts.get(pos);
    }

    public void remove(BlockPos pos) {
        this.hearts.remove(pos);
        this.func_76185_a();
    }

    public Iterable<GlassHeartData> all() {
        return this.hearts.values();
    }

    public static GlassHeartWorldData getDataFor(World w) {
        GlassHeartWorldData data;
        if (w.field_72995_K) {
            GlassHearts.LOG.warn("getDataFor called on the client-side");
        }
        if ((data = (GlassHeartWorldData)w.getPerWorldStorage().func_75742_a(GlassHeartWorldData.class, "glass_hearts")) == null) {
            data = new GlassHeartWorldData("glass_hearts");
            w.getPerWorldStorage().func_75745_a("glass_hearts", (WorldSavedData)data);
        }
        data.setWorld(w);
        return data;
    }

    private /* synthetic */ GlassHeartData lambda$readFromNBT$0() {
        return new GlassHeartData(this);
    }

    static /* synthetic */ GlassHeartData access$lambda$0(GlassHeartWorldData glassHeartWorldData) {
        return glassHeartWorldData.lambda$readFromNBT$0();
    }
}

