/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.itsnotreal.network;

import java.util.function.Supplier;
import net.mcreator.itsnotreal.ItsnotrealMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItsnotrealModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ItsnotrealMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.SeenEvilGuy = message.data.SeenEvilGuy;
                    variables.SeenEvilButNotScaryGuy = message.data.SeenEvilButNotScaryGuy;
                    variables.EyesClosedAndOpen = message.data.EyesClosedAndOpen;
                    variables.cooldownshits = message.data.cooldownshits;
                    variables.cooldownshits2 = message.data.cooldownshits2;
                    variables.cooldownstalkers = message.data.cooldownstalkers;
                    variables.messagecooldown = message.data.messagecooldown;
                    variables.musiccooldown = message.data.musiccooldown;
                    variables.cooldownscarers = message.data.cooldownscarers;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean SeenEvilGuy = false;
        public boolean SeenEvilButNotScaryGuy = false;
        public boolean EyesClosedAndOpen = false;
        public boolean cooldownshits = false;
        public double cooldownshits2 = -36000.0;
        public double cooldownstalkers = -10000.0;
        public double messagecooldown = 0.0;
        public double musiccooldown = -10000.0;
        public double cooldownscarers = -18000.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ItsnotrealMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("SeenEvilGuy", this.SeenEvilGuy);
            nbt.m_128379_("SeenEvilButNotScaryGuy", this.SeenEvilButNotScaryGuy);
            nbt.m_128379_("EyesClosedAndOpen", this.EyesClosedAndOpen);
            nbt.m_128379_("cooldownshits", this.cooldownshits);
            nbt.m_128347_("cooldownshits2", this.cooldownshits2);
            nbt.m_128347_("cooldownstalkers", this.cooldownstalkers);
            nbt.m_128347_("messagecooldown", this.messagecooldown);
            nbt.m_128347_("musiccooldown", this.musiccooldown);
            nbt.m_128347_("cooldownscarers", this.cooldownscarers);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.SeenEvilGuy = nbt.m_128471_("SeenEvilGuy");
            this.SeenEvilButNotScaryGuy = nbt.m_128471_("SeenEvilButNotScaryGuy");
            this.EyesClosedAndOpen = nbt.m_128471_("EyesClosedAndOpen");
            this.cooldownshits = nbt.m_128471_("cooldownshits");
            this.cooldownshits2 = nbt.m_128459_("cooldownshits2");
            this.cooldownstalkers = nbt.m_128459_("cooldownstalkers");
            this.messagecooldown = nbt.m_128459_("messagecooldown");
            this.musiccooldown = nbt.m_128459_("musiccooldown");
            this.cooldownscarers = nbt.m_128459_("cooldownscarers");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("itsnotreal", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.SeenEvilGuy = original.SeenEvilGuy;
            clone.SeenEvilButNotScaryGuy = original.SeenEvilButNotScaryGuy;
            clone.EyesClosedAndOpen = original.EyesClosedAndOpen;
            clone.cooldownshits = original.cooldownshits;
            clone.cooldownshits2 = original.cooldownshits2;
            clone.cooldownstalkers = original.cooldownstalkers;
            clone.messagecooldown = original.messagecooldown;
            clone.musiccooldown = original.musiccooldown;
            clone.cooldownscarers = original.cooldownscarers;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

