/*
 * Decompiled with CFR 0.152.
 */
package mei.arisuwu.deermod;

import java.util.function.Function;
import java.util.function.Supplier;
import mei.arisuwu.deermod.ModEntities;
import mei.arisuwu.deermod.ModFoodComponents;
import mei.arisuwu.deermod.ModResourceLocation;
import mei.arisuwu.deermod.ModTags;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;

public class ModItems {
    public static Supplier<Item> VENISON;
    public static Supplier<Item> COOKED_VENISON;
    public static Supplier<Item> ANTLERS;
    public static Supplier<Item> DEER_SPAWN_EGG;
    public static Supplier<Item> DEER_CRACKERS;
    public static Supplier<Item> DEER_CRACKERS_ON_A_STICK;
    public static Supplier<Item> DEER_BANNER_PATTERN;

    public ModItems() {
        DEER_SPAWN_EGG = this.registerItem("deer_spawn_egg", (Item.Properties settings) -> new SpawnEggItem(ModEntities.DEER.get(), settings));
        ANTLERS = this.registerItem("antlers");
        VENISON = this.registerFoodItem("venison", ModFoodComponents.VENISON);
        COOKED_VENISON = this.registerFoodItem("cooked_venison", ModFoodComponents.COOKED_VENISON);
        DEER_CRACKERS = this.registerFoodItem("deer_crackers", ModFoodComponents.DEER_CRACKERS);
        DEER_CRACKERS_ON_A_STICK = this.registerItem("deer_crackers_on_a_stick", settings -> new FoodOnAStickItem(ModEntities.DEER.get(), 4, settings), new Item.Properties().durability(100));
        DEER_BANNER_PATTERN = this.registerItem("deer_banner_pattern", new Item.Properties().stacksTo(1).component(DataComponents.PROVIDES_BANNER_PATTERNS, ModTags.DEER_PATTERN_ITEM));
    }

    protected Supplier<Item> registerItem(String name, Function<Item.Properties, Item> factory, Item.Properties settings) {
        Item item = Items.registerItem((ResourceKey)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ModResourceLocation.of(name)), factory, (Item.Properties)settings);
        return () -> item;
    }

    private Supplier<Item> registerFoodItem(String name, FoodProperties foodComponent) {
        return this.registerItem(name, new Item.Properties().food(foodComponent));
    }

    private Supplier<Item> registerItem(String name, Function<Item.Properties, Item> factory) {
        return this.registerItem(name, factory, new Item.Properties());
    }

    private Supplier<Item> registerItem(String name, Item.Properties settings) {
        return this.registerItem(name, Item::new, settings);
    }

    private Supplier<Item> registerItem(String name) {
        return this.registerItem(name, Item::new, new Item.Properties());
    }
}

