/*
 * Decompiled with CFR 0.152.
 */
package mei.arisuwu.deermod.entity.deer;

import mei.arisuwu.deermod.ModItems;
import mei.arisuwu.deermod.ModLootTables;
import mei.arisuwu.deermod.ModResourceLocation;
import mei.arisuwu.deermod.ModTags;
import mei.arisuwu.deermod.entity.deer.DeerEntitySaddledComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeerEntity
extends Animal
implements Shearable,
ItemSteerable {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState eatGrassAnimationState = new AnimationState();
    private EatBlockGoal eatGrassGoal;
    private int eatGrassTimer = 0;
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.defineId(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final DeerEntitySaddledComponent saddledComponent = new DeerEntitySaddledComponent(this.entityData, BOOST_TIME);

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public DeerEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> stack.is(ModItems.DEER_CRACKERS_ON_A_STICK.get()), false));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> stack.is(ModTags.DEER_FOOD), false));
        this.eatGrassGoal = new EatBlockGoal((Mob)this);
        this.goalSelector.addGoal(4, (Goal)this.eatGrassGoal);
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHEARED, (Object)false);
        builder.define(BOOST_TIME, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (BOOST_TIME.equals(data) && this.level().isClientSide) {
            this.saddledComponent.boost();
        }
        super.onSyncedDataUpdated(data);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("Sheared", this.isSheared());
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setSheared(valueInput.getBooleanOr("Sheared", false));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModTags.DEER_FOOD);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(ModResourceLocation.of("deer"))).create((Level)world, EntitySpawnReason.BREEDING);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.SHEARS) && this.readyForShearing()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                this.shear(serverWorld, SoundSource.PLAYERS, itemStack);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                itemStack.hurtAndBreak(1, (LivingEntity)player, DeerEntity.getSlotForHand((InteractionHand)hand));
                return InteractionResult.SUCCESS_SERVER;
            }
            return InteractionResult.CONSUME;
        }
        if (!this.isFood(itemStack) && this.isSaddled() && !this.isVehicle() && !player.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isEquippableInSlot(itemStack, EquipmentSlot.SADDLE)) {
            return itemStack.interactLivingEntity(player, (LivingEntity)this, hand);
        }
        return super.mobInteract(player, hand);
    }

    public void shear(ServerLevel world, SoundSource shearedSoundCategory, ItemStack shears) {
        world.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        this.dropFromShearingLootTable(world, ModLootTables.DEER_SHEARING, shears, (serverWorld, itemStack) -> this.spawnAtLocation((ServerLevel)serverWorld, (ItemStack)itemStack, 1.0f));
        this.setSheared(true);
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby() && !this.isSheared();
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(SHEARED, (Object)sheared);
    }

    protected void customServerAiStep(ServerLevel world) {
        this.eatGrassTimer = this.eatGrassGoal.getEatAnimationTick();
        super.customServerAiStep(world);
    }

    public void aiStep() {
        if (this.level().isClientSide()) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        super.aiStep();
    }

    public void tick() {
        super.tick();
        this.updateEatGrassAnimation();
    }

    public void handleEntityEvent(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        }
        super.handleEntityEvent(status);
    }

    public void ate() {
        super.ate();
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    private void updateEatGrassAnimation() {
        if (this.eatGrassTimer > 0) {
            this.eatGrassAnimationState.startIfStopped(this.tickCount);
        } else {
            this.eatGrassAnimationState.stop();
        }
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        if (slot == EquipmentSlot.SADDLE) {
            return this.isAlive() && !this.isBaby();
        }
        return super.canUseSlot(slot);
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.SADDLE || super.canDispenserEquipIntoSlot(slot);
    }

    protected void tickRidden(Player controllingPlayer, Vec3 movementInput) {
        super.tickRidden(controllingPlayer, movementInput);
        this.setRot(controllingPlayer.getYRot(), controllingPlayer.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.saddledComponent.tickBoost();
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Player player;
        Entity entity;
        return this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player && (player = (Player)entity).isHolding(ModItems.DEER_CRACKERS_ON_A_STICK.get()) ? player : super.getControllingPassenger();
    }

    protected Vec3 getRiddenInput(Player controllingPlayer, Vec3 movementInput) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float getRiddenSpeed(Player controllingPlayer) {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)0.4f * (double)this.saddledComponent.getMovementSpeedMultiplier());
    }

    public Vec3 getPassengerRidingPosition(Entity passenger) {
        return super.getPassengerRidingPosition(passenger).add(0.0, (double)-0.55f, 0.0);
    }

    public boolean boost() {
        return this.saddledComponent.boost(this.getRandom());
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() != Direction.Axis.Y) {
            int[][] is = DismountHelper.offsetsForDirection((Direction)direction);
            BlockPos blockPos = this.blockPosition();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Pose entityPose : passenger.getDismountPoses()) {
                AABB box = passenger.getLocalBoundsForPose(entityPose);
                for (int[] js : is) {
                    mutable.set(blockPos.getX() + js[0], blockPos.getY(), blockPos.getZ() + js[1]);
                    double d = this.level().getBlockFloorHeight((BlockPos)mutable);
                    if (!DismountHelper.isBlockFloorValid((double)d)) continue;
                    Vec3 vec3d = Vec3.upFromBottomCenterOf((Vec3i)mutable, (double)d);
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)box.move(vec3d))) continue;
                    passenger.setPose(entityPose);
                    return vec3d;
                }
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }
}

