/*
 * Decompiled with CFR 0.152.
 */
package mei.arisuwu.deermod.entity.deer;

import mei.arisuwu.deermod.entity.deer.DeerEntityRenderState;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;

public class DeerEntityModel
extends EntityModel<DeerEntityRenderState> {
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart antlers;
    private final ModelPart body;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart saddle;
    private final KeyframeAnimation eatGrassAnimation;
    private static final AnimationDefinition EAT_GRASS = AnimationDefinition.Builder.withLength((float)2.0f).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167f, KeyframeAnimations.degreeVec((float)90.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)105.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.9167f, KeyframeAnimations.degreeVec((float)95.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0833f, KeyframeAnimations.degreeVec((float)105.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.25f, KeyframeAnimations.degreeVec((float)95.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.4167f, KeyframeAnimations.degreeVec((float)105.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).build();

    public DeerEntityModel(ModelPart root) {
        super(root);
        this.neck = root.getChild("neck");
        this.head = this.neck.getChild("head");
        this.antlers = this.head.getChild("antlers");
        this.body = root.getChild("body");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.rightHindLeg = this.body.getChild("right_hind_leg");
        this.leftHindLeg = this.body.getChild("left_hind_leg");
        this.saddle = root.getChild("saddle");
        this.eatGrassAnimation = EAT_GRASS.bake(root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition neck = modelPartData.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)9.0f, (float)-11.0f));
        PartDefinition neck_r1 = neck.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(32, 43).addBox(-2.0f, -10.0f, -1.5f, 4.0f, 12.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)-0.5f, (float)0.2356f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 31).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(14, 47).addBox(-2.0f, 0.0f, -6.0f, 4.0f, 3.0f, 3.0f).texOffs(0, 54).addBox(-1.0f, 0.0f, -7.0f, 2.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)-13.0f, (float)-2.0f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)-2.0f, (float)1.0f));
        PartDefinition ear_r1 = right_ear.addOrReplaceChild("ear_r1", CubeListBuilder.create().texOffs(6, 54).addBox(-4.0f, -2.0f, -1.0f, 2.0f, 2.0f, 1.0f).texOffs(22, 53).addBox(-2.0f, -2.0f, -1.0f, 3.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.6981f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-2.0f, (float)1.0f));
        PartDefinition ear_r2 = left_ear.addOrReplaceChild("ear_r2", CubeListBuilder.create().texOffs(6, 54).mirror().addBox(2.0f, -2.0f, -1.0f, 2.0f, 2.0f, 1.0f).mirror(false).texOffs(22, 53).mirror().addBox(-1.0f, -2.0f, -1.0f, 3.0f, 3.0f, 1.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)-0.6981f));
        PartDefinition antlers = head.addOrReplaceChild("antlers", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)28.0f, (float)12.0f));
        antlers.addOrReplaceChild("antlers_l", CubeListBuilder.create().texOffs(28, 47).mirror().addBox(0.0f, -2.0f, -23.0f, 1.0f, 2.0f, 1.0f).mirror(false).texOffs(28, 47).mirror().addBox(1.0f, -4.0f, -22.0f, 1.0f, 2.0f, 1.0f).mirror(false).texOffs(28, 47).mirror().addBox(2.0f, -5.0f, -21.0f, 1.0f, 2.0f, 1.0f).mirror(false).texOffs(28, 50).mirror().addBox(2.0f, -7.0f, -22.0f, 1.0f, 1.0f, 1.0f).mirror(false).texOffs(28, 47).mirror().addBox(3.0f, -6.0f, -21.0f, 1.0f, 2.0f, 1.0f).mirror(false).texOffs(28, 47).mirror().addBox(4.0f, -7.0f, -22.0f, 1.0f, 2.0f, 1.0f).mirror(false).texOffs(28, 50).mirror().addBox(5.0f, -8.0f, -23.0f, 1.0f, 1.0f, 1.0f).mirror(false).texOffs(28, 50).mirror().addBox(0.0f, -5.0f, -21.0f, 1.0f, 1.0f, 1.0f).mirror(false), PartPose.offset((float)1.0f, (float)-31.0f, (float)11.0f));
        antlers.addOrReplaceChild("antlers_r", CubeListBuilder.create().texOffs(28, 47).addBox(-2.0f, -33.0f, -12.0f, 1.0f, 2.0f, 1.0f).texOffs(28, 47).addBox(-3.0f, -35.0f, -11.0f, 1.0f, 2.0f, 1.0f).texOffs(28, 47).addBox(-4.0f, -36.0f, -10.0f, 1.0f, 2.0f, 1.0f).texOffs(28, 50).addBox(-4.0f, -38.0f, -11.0f, 1.0f, 1.0f, 1.0f).texOffs(28, 47).addBox(-5.0f, -37.0f, -10.0f, 1.0f, 2.0f, 1.0f).texOffs(28, 47).addBox(-6.0f, -38.0f, -11.0f, 1.0f, 2.0f, 1.0f).texOffs(28, 50).addBox(-7.0f, -39.0f, -12.0f, 1.0f, 1.0f, 1.0f).texOffs(28, 50).addBox(-2.0f, -36.0f, -11.0f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 47).addBox(-2.0f, -21.0f, 8.0f, 4.0f, 4.0f, 3.0f).texOffs(14, 53).addBox(-1.0f, -23.0f, 10.0f, 2.0f, 4.0f, 2.0f).texOffs(0, 0).addBox(-4.0f, -19.0f, -13.0f, 8.0f, 9.0f, 22.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 43).addBox(-0.5f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f), PartPose.offset((float)-3.5f, (float)-10.0f, (float)-10.0f));
        body.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 43).mirror().addBox(-1.5f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f).mirror(false), PartPose.offset((float)3.5f, (float)-10.0f, (float)-10.0f));
        body.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 43).addBox(-0.5f, 0.0f, -2.0f, 2.0f, 10.0f, 2.0f), PartPose.offset((float)-3.5f, (float)-10.0f, (float)8.0f));
        body.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 43).mirror().addBox(-1.5f, 0.0f, -2.0f, 2.0f, 10.0f, 2.0f).mirror(false), PartPose.offset((float)3.5f, (float)-10.0f, (float)8.0f));
        modelPartData.addOrReplaceChild("saddle", CubeListBuilder.create().texOffs(0, 31).addBox(-4.0f, -5.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.22f)), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setupAnim(DeerEntityRenderState livingEntityRenderState) {
        super.setupAnim((EntityRenderState)livingEntityRenderState);
        this.saddle.visible = livingEntityRenderState.saddled;
        this.head.xRot = livingEntityRenderState.xRot * ((float)Math.PI / 180);
        this.head.yRot = livingEntityRenderState.yRot * ((float)Math.PI / 180);
        float f = livingEntityRenderState.walkAnimationPos;
        float g = livingEntityRenderState.walkAnimationSpeed;
        this.rightHindLeg.xRot = Mth.cos((float)(f * 0.6662f)) * 1.4f * g;
        this.leftHindLeg.xRot = Mth.cos((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
        this.rightFrontLeg.xRot = Mth.cos((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
        this.leftFrontLeg.xRot = Mth.cos((float)(f * 0.6662f)) * 1.4f * g;
        this.antlers.visible = !livingEntityRenderState.sheared && !livingEntityRenderState.isBaby;
        this.eatGrassAnimation.apply(livingEntityRenderState.eatGrassAnimationState, livingEntityRenderState.ageInTicks);
    }
}

