/*
 * Decompiled with CFR 0.152.
 */
package mei.arisuwu.deermod.entity.deer;

import com.mojang.blaze3d.vertex.PoseStack;
import mei.arisuwu.deermod.ModModelLayers;
import mei.arisuwu.deermod.ModResourceLocation;
import mei.arisuwu.deermod.entity.deer.DeerEntity;
import mei.arisuwu.deermod.entity.deer.DeerEntityModel;
import mei.arisuwu.deermod.entity.deer.DeerEntityRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class DeerEntityRenderer
extends MobRenderer<DeerEntity, DeerEntityRenderState, DeerEntityModel> {
    private static final float BASE_SHADOW_RADIUS = 0.75f;
    private static final float BABY_MULTIPLIER = 0.6f;

    public DeerEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DeerEntityModel(context.bakeLayer(ModModelLayers.DEER)), 0.75f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(DeerEntityRenderState state) {
        return ModResourceLocation.of("textures/entity/deer/deer.png");
    }

    @NotNull
    public DeerEntityRenderState createRenderState() {
        return new DeerEntityRenderState();
    }

    public void extractRenderState(DeerEntity deerEntity, DeerEntityRenderState deerEntityRenderState, float delta) {
        super.extractRenderState((LivingEntity)deerEntity, (LivingEntityRenderState)deerEntityRenderState, delta);
        deerEntityRenderState.sheared = deerEntity.isSheared();
        deerEntityRenderState.saddled = deerEntity.isSaddled();
        deerEntityRenderState.eatGrassAnimationState.copyFrom(deerEntity.eatGrassAnimationState);
    }

    public void render(DeerEntityRenderState livingEntityRenderState, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        if (livingEntityRenderState.isBaby) {
            matrixStack.scale(0.6f, 0.6f, 0.6f);
        } else {
            matrixStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.render((LivingEntityRenderState)livingEntityRenderState, matrixStack, vertexConsumerProvider, i);
    }
}

