/*
 * Decompiled with CFR 0.152.
 */
package mei.arisuwu.deermod.entity.deer;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class DeerEntitySaddledComponent {
    private final SynchedEntityData dataTracker;
    private final EntityDataAccessor<Integer> boostTime;
    private boolean boosted;
    private int boostedTime;

    public DeerEntitySaddledComponent(SynchedEntityData dataTracker, EntityDataAccessor<Integer> boostTime) {
        this.dataTracker = dataTracker;
        this.boostTime = boostTime;
    }

    public void boost() {
        this.boosted = true;
        this.boostedTime = 0;
    }

    public boolean boost(RandomSource random) {
        if (this.boosted) {
            return false;
        }
        this.boosted = true;
        this.boostedTime = 0;
        this.dataTracker.set(this.boostTime, (Object)(random.nextInt(841) + 140));
        return true;
    }

    public void tickBoost() {
        if (this.boosted && this.boostedTime++ > this.getBoostTime()) {
            this.boosted = false;
        }
    }

    public float getMovementSpeedMultiplier() {
        return this.boosted ? 1.0f + 1.15f * Mth.sin((float)((float)this.boostedTime / (float)this.getBoostTime() * (float)Math.PI)) : 1.0f;
    }

    public int getBoostTime() {
        return (Integer)this.dataTracker.get(this.boostTime);
    }
}

