/*
 * Decompiled with CFR 0.152.
 */
package mei.arisuwu.deermod.neoforge;

import mei.arisuwu.deermod.ModEntities;
import mei.arisuwu.deermod.ModModelLayers;
import mei.arisuwu.deermod.entity.deer.DeerEntity;
import mei.arisuwu.deermod.entity.deer.DeerEntityModel;
import mei.arisuwu.deermod.entity.deer.DeerEntityRenderer;
import mei.arisuwu.deermod.neoforge.NeoforgeModCreativeTabs;
import mei.arisuwu.deermod.neoforge.NeoforgeModEntities;
import mei.arisuwu.deermod.neoforge.NeoforgeModItems;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

@Mod(value="deermod")
public final class NeoforgeMod {
    public NeoforgeMod(IEventBus modBus) {
        new NeoforgeModEntities(modBus);
        new NeoforgeModItems(modBus);
        new NeoforgeModCreativeTabs(modBus);
    }

    @EventBusSubscriber(modid="deermod", bus=EventBusSubscriber.Bus.MOD)
    public static class Events {
        @SubscribeEvent
        public static void onRegisteringLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(ModModelLayers.DEER, DeerEntityModel::getTexturedModelData);
        }

        @SubscribeEvent
        public static void onRegisteringAttributes(EntityAttributeCreationEvent event) {
            event.put(ModEntities.DEER.get(), DeerEntity.createAttributes().build());
        }

        @SubscribeEvent
        public static void onRegisteringSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register(ModEntities.DEER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }
    }

    @EventBusSubscriber(modid="deermod", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.DEER.get(), DeerEntityRenderer::new);
        }
    }
}

