/*
 * Decompiled with CFR 0.152.
 */
package mei.arisuwu.deermod.neoforge;

import java.util.Set;
import mei.arisuwu.deermod.ModCreativeTabs;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class NeoforgeModCreativeTabs
extends ModCreativeTabs {
    public NeoforgeModCreativeTabs(IEventBus eventBus) {
        eventBus.addListener(this::addEntriesToTab);
    }

    private void addEntriesToTab(BuildCreativeModeTabContentsEvent event) {
        this.entriesMap.getOrDefault(event.getTabKey(), Set.of()).forEach(entryMapping -> {
            switch (entryMapping.position) {
                case HEAD: {
                    entryMapping.getNewItemStacks().reversed().forEach(itemStack -> event.insertFirst(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                    break;
                }
                case BEFORE: {
                    entryMapping.getNewItemStacks().forEach(itemStack -> event.insertBefore(entryMapping.getExitingItemStack(), itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                    break;
                }
                case AFTER: {
                    entryMapping.getNewItemStacks().reversed().forEach(itemStack -> event.insertAfter(entryMapping.getExitingItemStack(), itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                    break;
                }
                case TAIL: {
                    event.acceptAll(entryMapping.getNewItemStacks());
                }
            }
        });
    }
}

