/*
 * Decompiled with CFR 0.152.
 */
package mei.arisuwu.deermod;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;

public record ModConfig(String configVersion, ModSpawnConfig habitatBiomesDeerSpawnSettings, ModSpawnConfig escapadeBiomesDeerSpawnSettings) {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting();
    public static ModConfig DEFAULT = new ModConfig("0.0.1", new ModSpawnConfig(14, 2, 6), new ModSpawnConfig(4, 1, 2));

    public static ModConfig load(Path path) {
        ModConfig modConfig;
        block9: {
            if (Files.notExists(path, new LinkOption[0])) {
                DEFAULT.save(path);
                return DEFAULT;
            }
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                modConfig = (ModConfig)GSON_BUILDER.create().fromJson((Reader)reader, ModConfig.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load the config file: {}\nLoading default setting instead", (Object)path, (Object)e);
                    return DEFAULT;
                }
            }
            reader.close();
        }
        return modConfig;
    }

    public void save(Path path) {
        String jsonContent = GSON_BUILDER.create().toJson((Object)this);
        try {
            Files.writeString(path, (CharSequence)jsonContent, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save the config file: {}", (Object)path, (Object)e);
        }
    }

    public record ModSpawnConfig(int spawnRate, int minGroupSize, int maxGroupSize) {
    }
}

