/*
 * Decompiled with CFR 0.152.
 */
package com.takaya7s.invisible_player_armor.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.takaya7s.invisible_player_armor.client.config.ModConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static File file = null;

    public static ModConfig loadConfig() {
        file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "invisible_player_armor.json");
        Gson gson = new Gson();
        ModConfig config = null;
        try {
            if (!file.exists()) {
                return ConfigManager.createDefaultConfig();
            }
            FileReader reader = new FileReader(file);
            config = (ModConfig)gson.fromJson((Reader)reader, ModConfig.class);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return config;
    }

    public static void saveConfig(ModConfig config) {
        if (file == null) {
            file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "invisible_player_armor.json");
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            config.version = 1;
            FileWriter writer = new FileWriter(file);
            gson.toJson((Object)config, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void backupConfig() {
        Path sourcePath = Path.of(FabricLoader.getInstance().getConfigDir().toString(), "invisible_player_armor.json");
        Path destPath = Path.of(FabricLoader.getInstance().getConfigDir().toString(), "invisible_player_armor.json.bak");
        if (Files.exists(sourcePath, new LinkOption[0])) {
            try {
                Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ModConfig createDefaultConfig() {
        if (file == null) {
            file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "invisible_player_armor.json");
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ModConfig config = new ModConfig();
        try {
            FileWriter writer = new FileWriter(file);
            gson.toJson((Object)config, (Appendable)writer);
            writer.close();
            return config;
        }
        catch (IOException e) {
            e.printStackTrace();
            return config;
        }
    }
}

