/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures;

import co.aikar.commands.PaperCommandManager;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import lombok.Generated;
import net.bitbylogic.structures.animation.StructureAnimationManager;
import net.bitbylogic.structures.animation.impl.BlockParticleAnimation;
import net.bitbylogic.structures.command.StructureCommand;
import net.bitbylogic.structures.lib.bitsutils.Placeholder;
import net.bitbylogic.structures.lib.bitsutils.message.config.MessageProvider;
import net.bitbylogic.structures.lib.bitsutils.message.format.Formatter;
import net.bitbylogic.structures.listener.StructureEditorListener;
import net.bitbylogic.structures.listener.StructureListener;
import net.bitbylogic.structures.manager.StructureManager;
import net.bitbylogic.structures.placeholder.StructurePlaceholderExpansion;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Structures
extends JavaPlugin {
    private final File structureFile = new File(this.getDataFolder(), "structures.yml");
    private YamlConfiguration structureConfig;
    private MessageProvider messageProvider;
    private PaperCommandManager commandManager;
    private StructureAnimationManager animationManager;
    private StructureManager structureManager;

    public void onEnable() {
        this.saveDefaultConfig();
        Formatter.registerConfig(new File(this.getDataFolder(), "config.yml"));
        if (!this.structureFile.exists()) {
            try {
                this.structureFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Failed to create structures file!", e);
            }
        }
        this.structureConfig = YamlConfiguration.loadConfiguration((File)this.structureFile);
        this.messageProvider = new MessageProvider(this.getConfig().getConfigurationSection("Messages"));
        this.messageProvider.getPlaceholders().add(s -> {
            if (!s.contains("%prefix%")) {
                return s;
            }
            return s.replace("%prefix%", this.messageProvider.getMessage("Prefix", new Placeholder[0]));
        });
        this.commandManager = new PaperCommandManager((Plugin)this);
        this.animationManager = new StructureAnimationManager();
        this.animationManager.registerAnimation(new BlockParticleAnimation());
        this.structureManager = new StructureManager(this, this.animationManager);
        this.commandManager.getCommandCompletions().registerCompletion("structureIds", context -> this.structureManager.getStructures().keySet());
        this.commandManager.getCommandCompletions().registerCompletion("animationIds", context -> this.animationManager.getRegisteredAnimations().keySet());
        this.commandManager.registerCommand(new StructureCommand(this.messageProvider, this.animationManager, this.structureManager));
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new StructureListener(this, this.structureManager), (Plugin)this);
        pluginManager.registerEvents((Listener)new StructureEditorListener(this.messageProvider, this.structureManager), (Plugin)this);
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new StructurePlaceholderExpansion(this.structureManager).register();
        }
    }

    public void onDisable() {
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (this.messageProvider != null) {
            this.messageProvider.reload(this.getConfig().getConfigurationSection("Messages"));
        }
        if (this.structureManager == null) {
            return;
        }
        this.structureConfig = YamlConfiguration.loadConfiguration((File)this.structureFile);
        this.structureManager.loadStructures();
    }

    public void saveStructureConfig() {
        try {
            this.structureConfig.save(this.structureFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Failed to save structures config!", e);
        }
    }

    @Generated
    public File getStructureFile() {
        return this.structureFile;
    }

    @Generated
    public YamlConfiguration getStructureConfig() {
        return this.structureConfig;
    }

    @Generated
    public MessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    @Generated
    public PaperCommandManager getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public StructureAnimationManager getAnimationManager() {
        return this.animationManager;
    }

    @Generated
    public StructureManager getStructureManager() {
        return this.structureManager;
    }
}

