/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.animation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import net.bitbylogic.structures.animation.StructureAnimation;
import org.jetbrains.annotations.Nullable;

public class StructureAnimationManager {
    private final Map<String, StructureAnimation> registeredAnimations = new HashMap<String, StructureAnimation>();

    public boolean registerAnimation(@NonNull StructureAnimation animation) {
        if (animation == null) {
            throw new NullPointerException("animation is marked non-null but is null");
        }
        if (this.registeredAnimations.containsKey(animation.getId().toLowerCase())) {
            return false;
        }
        this.registeredAnimations.put(animation.getId().toLowerCase(), animation);
        return true;
    }

    public Optional<StructureAnimation> getAnimation(@Nullable String id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.registeredAnimations.get(id.toLowerCase()));
    }

    public Map<String, StructureAnimation> getRegisteredAnimations() {
        return Map.copyOf(this.registeredAnimations);
    }
}

