/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.command;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Dependency;
import co.aikar.commands.annotation.Optional;
import co.aikar.commands.annotation.Subcommand;
import co.aikar.commands.annotation.Syntax;
import co.aikar.commands.bukkit.contexts.OnlinePlayer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import lombok.Generated;
import net.bitbylogic.packetblocks.PacketBlocks;
import net.bitbylogic.packetblocks.block.PacketBlock;
import net.bitbylogic.packetblocks.util.PacketBlockUtil;
import net.bitbylogic.structures.Structures;
import net.bitbylogic.structures.animation.StructureAnimation;
import net.bitbylogic.structures.animation.StructureAnimationManager;
import net.bitbylogic.structures.lib.bitsutils.Placeholder;
import net.bitbylogic.structures.lib.bitsutils.message.config.MessageProvider;
import net.bitbylogic.structures.lib.bitsutils.smallcaps.SmallCapsConverter;
import net.bitbylogic.structures.manager.StructureManager;
import net.bitbylogic.structures.structure.Structure;
import net.bitbylogic.structures.util.RotationUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="structure")
@CommandPermission(value="structures.admin")
public class StructureCommand
extends BaseCommand {
    private static final BlockData AIR_BLOCK_DATA = Material.AIR.createBlockData();
    private final MessageProvider messageProvider;
    private final StructureAnimationManager animationManager;
    private final StructureManager structureManager;
    @Dependency
    private Structures plugin;

    @Default
    public void onDefault(CommandSender sender) {
        this.displayCommandHelp(sender);
    }

    @Subcommand(value="help")
    public void onHelp(CommandSender sender) {
        this.displayCommandHelp(sender);
    }

    @Subcommand(value="reload")
    public void onReload(CommandSender sender) {
        this.plugin.reloadConfig();
        sender.sendMessage(this.messageProvider.getMessage("Configuration-Reloaded", new Placeholder[0]));
    }

    @Subcommand(value="info")
    public void onInfo(Player player) {
        RayTraceResult result = PacketBlockUtil.rayTrace((Player)player, (double)10.0);
        if (result == null || result.getHitBlock() == null) {
            player.sendMessage(this.messageProvider.getMessage("Info.Invalid-Location", new Placeholder[0]));
            return;
        }
        PacketBlocks.getInstance().getBlockManager().getBlock(result.getHitBlock().getLocation()).ifPresentOrElse(packetBlock -> {
            if (!packetBlock.hasMetadata("structure")) {
                player.sendMessage(this.messageProvider.getMessage("Info.No-Structure", new Placeholder[0]));
                return;
            }
            player.sendMessage(this.messageProvider.getMessage("Info.Structure-Info", new Placeholder("%id%", packetBlock.getMetadata("structure"))));
        }, () -> player.sendMessage(this.messageProvider.getMessage("Info.No-Structure", new Placeholder[0])));
    }

    @Subcommand(value="animation")
    @CommandCompletion(value="@structureIds * @animationIds")
    public void onAnimation(CommandSender sender, String structureId, StructureAnimation.Type animationType, String animationId) {
        Structure structure = this.structureManager.getStructures().get(structureId);
        if (structure == null) {
            sender.sendMessage(this.messageProvider.getMessage("Animation.Invalid-ID", new Placeholder[0]));
            return;
        }
        if (animationId.equalsIgnoreCase("none")) {
            switch (animationType) {
                case SHOW: {
                    structure.setAppearAnimationId(null);
                    sender.sendMessage(this.messageProvider.getMessage("Animation.Show-Animation-Set", new Placeholder("%id%", structureId), new Placeholder("%animationId%", "\u0274\u1d0f\u0274\u1d07")));
                    break;
                }
                case HIDE: {
                    structure.setDisappearAnimationId(null);
                    sender.sendMessage(this.messageProvider.getMessage("Animation.Hide-Animation-Set", new Placeholder("%id%", structureId), new Placeholder("%animationId%", "\u0274\u1d0f\u0274\u1d07")));
                }
            }
            this.structureManager.saveStructure(structureId);
            return;
        }
        this.animationManager.getAnimation(animationId).ifPresentOrElse(structureAnimation -> {
            switch (animationType) {
                case SHOW: {
                    structure.setAppearAnimationId(structureAnimation.getId());
                    sender.sendMessage(this.messageProvider.getMessage("Animation.Show-Animation-Set", new Placeholder("%id%", structureId), new Placeholder("%animationId%", animationId)));
                    break;
                }
                case HIDE: {
                    structure.setDisappearAnimationId(structureAnimation.getId());
                    sender.sendMessage(this.messageProvider.getMessage("Animation.Hide-Animation-Set", new Placeholder("%id%", structureId), new Placeholder("%animationId%", animationId)));
                }
            }
            this.structureManager.saveStructure(structureId);
        }, () -> sender.sendMessage(this.messageProvider.getMessage("Animation.Invalid-Animation", new Placeholder[0])));
    }

    @Subcommand(value="edit")
    @CommandCompletion(value="@structureIds")
    public void onEdit(Player player, @Optional String structureId) {
        String editingStructureId = this.structureManager.getEditorMode().get(player.getUniqueId());
        if (editingStructureId != null) {
            if (structureId != null && !editingStructureId.equals(structureId)) {
                this.messageProvider.getMessageList("Editor.Already-Editing", new Placeholder("%id%", editingStructureId)).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
                return;
            }
            Structure structure = this.structureManager.getStructures().get(structureId);
            Set<UUID> viewers = this.structureManager.getStructureViewers().get(structureId);
            if (viewers == null) {
                Bukkit.getLogger().log(Level.SEVERE, "Viewers entry for structure " + structureId + " does not exist");
                return;
            }
            viewers.add(player.getUniqueId());
            this.structureManager.getEditorModeLocations().get(player.getUniqueId()).forEach(location -> {
                BlockData blockData = location.getBlock().getBlockData();
                structure.getBlocks().put((Location)location, blockData);
                location.getBlock().setBlockData(AIR_BLOCK_DATA, false);
                PacketBlock packetBlock = this.structureManager.createPacketBlock(structure.getId(), (Location)location, blockData);
                packetBlock.addViewer(player);
                packetBlock.sendUpdate(player);
            });
            boolean saved = this.structureManager.saveStructure(editingStructureId);
            this.structureManager.getEditorMode().remove(player.getUniqueId());
            this.structureManager.getEditorModeLocations().remove(player.getUniqueId());
            if (structure.getBlocks().isEmpty()) {
                player.sendMessage(this.messageProvider.getMessage("Editor.Deleted-Structure", new Placeholder("%id%", editingStructureId)));
                return;
            }
            if (saved) {
                player.sendMessage(this.messageProvider.getMessage("Editor.Saved-Structure", new Placeholder("%id%", editingStructureId)));
                return;
            }
            player.sendMessage(this.messageProvider.getMessage("Editor.Failed-To-Save", new Placeholder[0]));
            return;
        }
        if (structureId == null) {
            player.sendMessage(this.messageProvider.getMessage("Editor.Missing-ID", new Placeholder[0]));
            return;
        }
        this.structureManager.getEditorMode().put(player.getUniqueId(), structureId);
        this.structureManager.getEditorModeLocations().put(player.getUniqueId(), new ArrayList());
        Structure structure = this.structureManager.getStructures().get(structureId);
        if (structure == null) {
            this.structureManager.createStructure(structureId);
            this.structureManager.addViewer(structureId, player);
            player.sendMessage(this.messageProvider.getMessage("Editor.Started-Editing-New", new Placeholder("%id%", structureId)));
            return;
        }
        this.structureManager.addViewer(structureId, player);
        player.sendMessage(this.messageProvider.getMessage("Editor.Started-Editing", new Placeholder("%id%", structureId)));
    }

    @Subcommand(value="copy")
    @CommandCompletion(value="@structureIds")
    @Syntax(value="<sourceId> <newId>")
    public void onCopy(Player player, String sourceId, String newId) {
        Structure source = this.structureManager.getStructures().get(sourceId);
        if (source == null) {
            player.sendMessage(this.messageProvider.getMessage("Copy.Invalid-Structure", new Placeholder("%id%", sourceId)));
            return;
        }
        if (this.structureManager.getStructures().containsKey(newId)) {
            player.sendMessage(this.messageProvider.getMessage("Copy.Duplicate-ID", new Placeholder("%id%", newId)));
            return;
        }
        RayTraceResult result = PacketBlockUtil.rayTrace((Player)player, (double)10.0);
        if (result == null || result.getHitBlock() == null) {
            player.sendMessage(this.messageProvider.getMessage("Copy.Invalid-Location", new Placeholder[0]));
            return;
        }
        Location target = result.getHitBlock().getLocation().toBlockLocation().add(result.getHitBlockFace().getDirection());
        Location center = this.getCopyCenter(player, source);
        Vector offset = target.toVector().subtract(center.toVector());
        int rotationSteps = Math.floorMod(Math.round(player.getLocation().getYaw() / 90.0f), 4);
        Structure newStructure = this.structureManager.createStructure(newId).orElse(null);
        if (newStructure == null) {
            player.sendMessage(this.messageProvider.getMessage("Copy.Failed-To-Copy", new Placeholder[0]));
            return;
        }
        Set<UUID> viewers = this.structureManager.getStructureViewers().get(newStructure.getId());
        if (viewers == null) {
            Bukkit.getLogger().log(Level.SEVERE, "Viewers entry for structure " + String.valueOf(newStructure) + " does not exist");
            return;
        }
        viewers.add(player.getUniqueId());
        for (Map.Entry<Location, BlockData> entry : source.getBlocks().entrySet()) {
            Location oldLoc = entry.getKey();
            BlockData blockData = entry.getValue().clone();
            double relX = oldLoc.getX() - center.getX();
            double relY = oldLoc.getY() - center.getY();
            double relZ = oldLoc.getZ() - center.getZ();
            Vector rotated = switch (rotationSteps) {
                case 1 -> new Vector(-relZ, relY, relX);
                case 2 -> new Vector(-relX, relY, -relZ);
                case 3 -> new Vector(relZ, relY, -relX);
                default -> new Vector(relX, relY, relZ);
            };
            Location newLoc = center.clone().add(rotated).add(offset);
            blockData.rotate(RotationUtil.getOppositeRotation(player.getYaw()));
            newStructure.getBlocks().put(newLoc, blockData);
            PacketBlock packetBlock = this.structureManager.createPacketBlock(newStructure.getId(), newLoc, blockData);
            packetBlock.addViewer(player);
            packetBlock.sendUpdate(player);
        }
        this.structureManager.saveStructure(newId);
        player.sendMessage(this.messageProvider.getMessage("Copy.Successfully-Copied", new Placeholder("%sourceId%", sourceId), new Placeholder("%newId%", newId), new Placeholder("%direction%", SmallCapsConverter.convert(player.getFacing().name()))));
    }

    @NotNull
    private Location getCopyCenter(Player player, Structure source) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Location loc : source.getBlocks().keySet()) {
            minX = Math.min(minX, loc.getBlockX());
            minY = Math.min(minY, loc.getBlockY());
            minZ = Math.min(minZ, loc.getBlockZ());
            maxX = Math.max(maxX, loc.getBlockX());
            maxY = Math.max(maxY, loc.getBlockY());
            maxZ = Math.max(maxZ, loc.getBlockZ());
        }
        return new Location(player.getWorld(), (double)(minX + maxX) / 2.0, (double)minY, (double)(minZ + maxZ) / 2.0);
    }

    @Subcommand(value="delete")
    @CommandCompletion(value="@structureIds")
    public void onDelete(CommandSender sender, String structureId) {
        Structure structure = this.structureManager.getStructures().get(structureId);
        if (structure == null) {
            sender.sendMessage(this.messageProvider.getMessage("Delete.Invalid-ID", new Placeholder[0]));
            return;
        }
        if (this.structureManager.deleteStructure(structureId)) {
            sender.sendMessage(this.messageProvider.getMessage("Delete.Successfully-Deleted", new Placeholder("%id%", structureId)));
            return;
        }
        sender.sendMessage(this.messageProvider.getMessage("Delete.Failed-To-Delete", new Placeholder("%id%", structureId)));
    }

    @Subcommand(value="view")
    @CommandCompletion(value="@structureIds @players *")
    private void onDefault(CommandSender sender, String structureId, @Optional OnlinePlayer target) {
        boolean toggle;
        Set<UUID> viewers = this.structureManager.getStructureViewers().get(structureId);
        if (viewers == null) {
            sender.sendMessage(this.messageProvider.getMessage("View.Invalid-ID", new Placeholder[0]));
            return;
        }
        Player player = target == null ? (Player)sender : target.getPlayer();
        boolean bl = toggle = !viewers.contains(player.getUniqueId());
        if (toggle) {
            this.structureManager.addViewer(structureId, player);
            if (target != null) {
                return;
            }
            sender.sendMessage(this.messageProvider.getMessage("View.Viewing-Enabled", new Placeholder("%id%", structureId)));
            return;
        }
        this.structureManager.removeViewer(structureId, player);
        if (target != null) {
            return;
        }
        sender.sendMessage(this.messageProvider.getMessage("View.Viewing-Disabled", new Placeholder("%id%", structureId)));
    }

    private void displayCommandHelp(CommandSender sender) {
        this.messageProvider.getMessageList("Command-Help", new Placeholder[0]).forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }

    @Generated
    public StructureCommand(MessageProvider messageProvider, StructureAnimationManager animationManager, StructureManager structureManager) {
        this.messageProvider = messageProvider;
        this.animationManager = animationManager;
        this.structureManager = structureManager;
    }
}

