/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class HashMapUtil {
    public static <K, V> String mapToString(HashMap<K, V> map, String entrySeparator, String valueSeparator, ObjectParser<K, V> parser) {
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        map.forEach((k, v) -> {
            if (parser != null) {
                builder.append(entrySeparator).append(parser.wrapKey(k)).append(valueSeparator).append(parser.wrapValue(v));
                return;
            }
            map.keySet().forEach(key -> builder.append(entrySeparator).append(key).append(valueSeparator).append(map.get(key)));
        });
        return builder.substring(1);
    }

    public static String mapToString(HashMap<?, ?> map) {
        return HashMapUtil.mapToString(map, ";", ":", null);
    }

    public static <K, V> String mapToString(HashMap<K, V> map, ObjectParser<K, V> parser) {
        return HashMapUtil.mapToString(map, ";", ":", parser);
    }

    public static <K, V> HashMap<K, V> mapFromString(ObjectWrapper<K, V> wrapper, String string) {
        return HashMapUtil.mapFromString(wrapper, ";", ":", string);
    }

    public static <K, V> HashMap<K, V> mapFromString(ObjectWrapper<K, V> wrapper, String entrySeparator, String valueSeparator, String string) {
        String[] mapData;
        HashMap<String, String> map = new HashMap<String, String>();
        if (string == null || string.isEmpty()) {
            return map;
        }
        for (String dataString : mapData = string.split(Pattern.quote(entrySeparator))) {
            String[] data = dataString.split(Pattern.quote(valueSeparator), 2);
            if (data.length < 2) continue;
            String key = wrapper == null ? data[0] : wrapper.wrapKey(data[0]);
            String value = wrapper == null ? data[1] : wrapper.wrapValue(data[1]);
            map.put(key, value);
        }
        return map;
    }

    public static <T, E> Set<T> getKeysByValue(Map<T, E> map, E value) {
        HashSet<T> keys = new HashSet<T>();
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static interface ObjectParser<K, V> {
        public String wrapKey(K var1);

        public String wrapValue(V var1);
    }

    public static interface ObjectWrapper<K, V> {
        public K wrapKey(String var1);

        public V wrapValue(String var1);
    }
}

