/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class ListUtil {
    public static String listToString(List<?> list) {
        return ListUtil.listToString(list, ":", null);
    }

    public static <O> String listToString(List<O> list, ListObjectWrapper<String, O> wrapper) {
        return ListUtil.listToString(list, ":", wrapper);
    }

    public static <O> String listToString(List<O> list, String separator, ListObjectWrapper<String, O> wrapper) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(separator);
        for (O o : list) {
            joiner.add(wrapper == null ? o.toString() : (CharSequence)wrapper.wrapValue(o));
        }
        return joiner.toString();
    }

    public static List<?> stringToList(String string, String separator) {
        return ListUtil.stringToList(string, separator, null);
    }

    public static List<?> stringToList(String string) {
        return ListUtil.stringToList(string, ":");
    }

    public static <V> List<V> stringToList(String string, String separator, ListObjectWrapper<V, String> wrapper) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.isEmpty()) {
            return list;
        }
        for (String value : string.split(separator)) {
            list.add(wrapper == null ? value : wrapper.wrapValue(value));
        }
        return list;
    }

    public static interface ListObjectWrapper<V, K> {
        public V wrapValue(K var1);
    }
}

