/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.bitbylogic.structures.lib.bitsutils.EnumUtil;
import net.bitbylogic.structures.lib.bitsutils.HashMapUtil;
import net.bitbylogic.structures.lib.bitsutils.ListUtil;
import net.bitbylogic.structures.lib.bitsutils.NumberUtil;

public enum StringProcessor {
    DEFAULT(new Class[]{String.class}, (type, value) -> value),
    INT(new Class[]{Integer.class, Integer.TYPE}, (type, value) -> Integer.parseInt(value)),
    LONG(new Class[]{Long.class, Long.TYPE}, (type, value) -> Long.parseLong(value)),
    DOUBLE(new Class[]{Double.class, Double.TYPE}, (type, value) -> Double.parseDouble(value)),
    FLOAT(new Class[]{Float.class, Float.TYPE}, (type, value) -> Float.valueOf(Float.parseFloat(value))),
    SHORT(new Class[]{Short.class, Short.TYPE}, (type, value) -> Short.parseShort(value)),
    BYTE(new Class[]{Byte.class, Byte.TYPE}, (type, value) -> Byte.parseByte(value)),
    BOOLEAN(new Class[]{Boolean.class, Boolean.TYPE}, (type, value) -> {
        if (NumberUtil.isNumber(value)) {
            return value.equalsIgnoreCase("1");
        }
        return Boolean.parseBoolean(value);
    }),
    CHAR(new Class[]{Character.class, Character.TYPE}, (type, value) -> Character.valueOf(value.isEmpty() ? (char)'A' : value.charAt(0))),
    UUID(new Class[]{UUID.class}, (type, value) -> java.util.UUID.fromString(value)),
    ENUM(new Class[]{Enum.class}, (type, value) -> {
        Class enumClass;
        if (type instanceof Class && Enum.class.isAssignableFrom(enumClass = (Class)type)) {
            Class casted = enumClass;
            return EnumUtil.getValue(casted, value, null);
        }
        return null;
    });

    private final Class<?>[] dataTypes;
    private final StringProcessorFunction<?> processor;

    public static Object findAndProcess(Type type, String value) {
        if (value == null || value.isEmpty()) {
            if (type instanceof ParameterizedType) {
                Class mapClass;
                Class rawClass;
                ParameterizedType pt = (ParameterizedType)type;
                Type raw = pt.getRawType();
                if (raw instanceof Class && List.class.isAssignableFrom(rawClass = (Class)raw)) {
                    return List.of();
                }
                if (raw instanceof Class && Map.class.isAssignableFrom(mapClass = (Class)raw)) {
                    return new HashMap();
                }
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (List.class.isAssignableFrom(clazz)) {
                    return List.of();
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    return new HashMap();
                }
            }
            return "";
        }
        if (type instanceof ParameterizedType) {
            Class mapClass;
            Class rawClass;
            ParameterizedType pt = (ParameterizedType)type;
            Type raw = pt.getRawType();
            Type[] args = pt.getActualTypeArguments();
            if (raw instanceof Class && List.class.isAssignableFrom(rawClass = (Class)raw)) {
                Type elementType = args[0];
                return ListUtil.stringToList(value, ":", string -> StringProcessor.findAndProcess(elementType, string));
            }
            if (raw instanceof Class && Map.class.isAssignableFrom(mapClass = (Class)raw)) {
                final Type keyType = args[0];
                final Type valueType = args[1];
                return HashMapUtil.mapFromString(new HashMapUtil.ObjectWrapper<Object, Object>(){

                    @Override
                    public Object wrapKey(String key) {
                        return StringProcessor.findAndProcess(keyType, key);
                    }

                    @Override
                    public Object wrapValue(String val) {
                        return StringProcessor.findAndProcess(valueType, val);
                    }
                }, value);
            }
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            for (StringProcessor processor : StringProcessor.values()) {
                for (Class<?> supported : processor.getDataTypes()) {
                    if (!supported.isAssignableFrom(clazz)) continue;
                    return processor.getProcessor().process(clazz, value);
                }
            }
        }
        return value;
    }

    public static String toStringFromObject(Type type, Object value) {
        if (value == null) {
            return "";
        }
        if (type instanceof ParameterizedType) {
            Class mapClass;
            Class rawClass;
            ParameterizedType pt = (ParameterizedType)type;
            Type raw = pt.getRawType();
            Type[] args = pt.getActualTypeArguments();
            if (raw instanceof Class && List.class.isAssignableFrom(rawClass = (Class)raw)) {
                Type elementType = args[0];
                return ListUtil.listToString((List)value, ":", v -> StringProcessor.toStringFromObject(elementType, v));
            }
            if (raw instanceof Class && Map.class.isAssignableFrom(mapClass = (Class)raw)) {
                final Type keyType = args[0];
                final Type valueType = args[1];
                HashMap castedMap = new HashMap((Map)value);
                return HashMapUtil.mapToString(castedMap, new HashMapUtil.ObjectParser<Object, Object>(){

                    @Override
                    public String wrapKey(Object key) {
                        return StringProcessor.toStringFromObject(keyType, key);
                    }

                    @Override
                    public String wrapValue(Object val) {
                        return StringProcessor.toStringFromObject(valueType, val);
                    }
                });
            }
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isEnum()) {
                return ((Enum)value).name();
            }
            return value.toString();
        }
        return value.toString();
    }

    public static Object findAndProcess(Class<?> clazz, String value) {
        return StringProcessor.findAndProcess(clazz, value);
    }

    public static String toStringFromObject(Class<?> clazz, Object value) {
        return StringProcessor.toStringFromObject(clazz, value);
    }

    @Generated
    private StringProcessor(Class<?>[] dataTypes, StringProcessorFunction<?> processor) {
        this.dataTypes = dataTypes;
        this.processor = processor;
    }

    @Generated
    public Class<?>[] getDataTypes() {
        return this.dataTypes;
    }

    @Generated
    public StringProcessorFunction<?> getProcessor() {
        return this.processor;
    }

    private static interface StringProcessorFunction<V> {
        public V process(Type var1, String var2);
    }
}

