/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bitbylogic.structures.lib.bitsutils.action.ActionParser;
import net.bitbylogic.structures.lib.bitsutils.action.ActionRegistry;
import net.bitbylogic.structures.lib.bitsutils.action.ConfiguredMetadataActionData;
import net.bitbylogic.structures.lib.bitsutils.action.impl.BroadcastMessageAction;
import net.bitbylogic.structures.lib.bitsutils.action.impl.BroadcastSoundAction;
import net.bitbylogic.structures.lib.bitsutils.action.impl.ConsoleCommandAction;
import net.bitbylogic.structures.lib.bitsutils.action.impl.PlayerCommandAction;
import net.bitbylogic.structures.lib.bitsutils.action.impl.PlayerMessageAction;
import net.bitbylogic.structures.lib.bitsutils.action.impl.PlayerSoundAction;
import net.bitbylogic.structures.lib.bitsutils.action.parsed.ParsedAction;
import net.bitbylogic.structures.lib.bitsutils.action.reference.ActionReference;
import net.bitbylogic.structures.lib.bitsutils.config.metadata.ConfiguredMetadata;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class BukkitActionParser
extends ActionParser {
    public static List<ParsedAction> parseActions(@Nullable ConfigurationSection actionsSection) {
        ArrayList<ParsedAction> actions = new ArrayList<ParsedAction>();
        if (actionsSection == null) {
            return actions;
        }
        actionsSection.getKeys(false).forEach(key -> {
            if (actionsSection.isString(key)) {
                String data = actionsSection.getString(key);
                if (data == null) {
                    return;
                }
                ActionParser.parseAction(data).ifPresent(actions::add);
                return;
            }
            if (actionsSection.isList(key)) {
                List list = actionsSection.getStringList(key);
                actions.addAll(ActionParser.parseActions(list));
                return;
            }
            ConfigurationSection actionSection = actionsSection.getConfigurationSection(key);
            if (actionSection == null) {
                return;
            }
            BukkitActionParser.parseAction(actionSection).ifPresent(actions::add);
        });
        return actions;
    }

    public static Optional<ParsedAction> parseAction(@Nullable ConfigurationSection conditionSection) {
        if (conditionSection == null) {
            return Optional.empty();
        }
        String id = conditionSection.getString("Condition-ID");
        if (id == null) {
            return Optional.empty();
        }
        ConfigurationSection metadataSection = conditionSection.getConfigurationSection("Metadata");
        ConfiguredMetadata metadata = new ConfiguredMetadata(metadataSection);
        return Optional.of(new ParsedAction(new ActionReference(id), new ConfiguredMetadataActionData(metadata)));
    }

    static {
        ActionRegistry.register(new BroadcastMessageAction(), new BroadcastSoundAction(), new ConsoleCommandAction(), new PlayerCommandAction(), new PlayerMessageAction(), new PlayerSoundAction());
    }
}

